/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.xml.jackson;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import io.github.astrapi69.throwable.RuntimeExceptionDecorator;
import io.github.astrapi69.xml.jackson.factory.XmlMapperFactory;
import java.io.File;
import java.util.Objects;
import lombok.NonNull;

public final class XmlFileToObjectExtensions {
    private XmlFileToObjectExtensions() {
    }

    public static <T> T toObject(@NonNull File file, @NonNull Class<T> clazz) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return (T)RuntimeExceptionDecorator.decorate(() -> XmlMapperFactory.newXmlMapper().readValue(file, clazz));
    }

    public static <T> T toObject(@NonNull File file, @NonNull TypeReference<T> typeReference) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (typeReference == null) {
            throw new NullPointerException("typeReference is marked non-null but is null");
        }
        return XmlFileToObjectExtensions.toObject(file, typeReference, XmlMapperFactory.newXmlMapper());
    }

    public static <T> T toObject(@NonNull File file, @NonNull JavaType javaType) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (javaType == null) {
            throw new NullPointerException("javaType is marked non-null but is null");
        }
        return XmlFileToObjectExtensions.toObject(file, javaType, XmlMapperFactory.newXmlMapper());
    }

    public static <T> T toObject(@NonNull File file, @NonNull TypeReference<T> typeReference, @NonNull XmlMapper xmlMapper) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (typeReference == null) {
            throw new NullPointerException("typeReference is marked non-null but is null");
        }
        if (xmlMapper == null) {
            throw new NullPointerException("xmlMapper is marked non-null but is null");
        }
        return (T)RuntimeExceptionDecorator.decorate(() -> xmlMapper.readValue(file, typeReference));
    }

    public static <T> T toObject(@NonNull File file, @NonNull JavaType javaType, @NonNull XmlMapper xmlMapper) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        Objects.requireNonNull(javaType);
        Objects.requireNonNull(xmlMapper);
        return (T)RuntimeExceptionDecorator.decorate(() -> xmlMapper.readValue(file, javaType));
    }
}

