/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.xml.jackson;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import io.github.astrapi69.throwable.RuntimeExceptionDecorator;
import io.github.astrapi69.xml.jackson.XmlToObjectExtensions;
import io.github.astrapi69.xml.jackson.api.JacksonXmlToObject;
import lombok.NonNull;

public class XmlToObjectConverter
implements JacksonXmlToObject {
    public <T> T toObject(@NonNull String xmlString, @NonNull Class<T> clazz) {
        if (xmlString == null) {
            throw new NullPointerException("xmlString is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return (T)RuntimeExceptionDecorator.decorate(() -> XmlToObjectExtensions.toObject(xmlString, clazz));
    }

    @Override
    public <T> T toObject(@NonNull String xmlString, @NonNull TypeReference<T> typeReference) {
        if (xmlString == null) {
            throw new NullPointerException("xmlString is marked non-null but is null");
        }
        if (typeReference == null) {
            throw new NullPointerException("typeReference is marked non-null but is null");
        }
        return (T)RuntimeExceptionDecorator.decorate(() -> XmlToObjectExtensions.toObject(xmlString, typeReference));
    }

    @Override
    public <T> T toObject(@NonNull String xmlString, @NonNull JavaType javaType) {
        if (xmlString == null) {
            throw new NullPointerException("xmlString is marked non-null but is null");
        }
        if (javaType == null) {
            throw new NullPointerException("javaType is marked non-null but is null");
        }
        return (T)RuntimeExceptionDecorator.decorate(() -> XmlToObjectExtensions.toObject(xmlString, javaType));
    }
}

