/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.xml.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import io.github.astrapi69.xml.jackson.factory.XmlMapperFactory;
import java.util.Objects;

public final class XmlToObjectExtensions {
    private XmlToObjectExtensions() {
    }

    public static <T> T toObject(String xmlString, Class<T> clazz) throws JsonProcessingException {
        Objects.requireNonNull(xmlString);
        Objects.requireNonNull(clazz);
        return (T)XmlMapperFactory.newXmlMapper().readValue(xmlString, clazz);
    }

    public static <T> T toObject(String xmlString, TypeReference<T> typeReference) throws JsonProcessingException {
        Objects.requireNonNull(xmlString);
        Objects.requireNonNull(typeReference);
        return XmlToObjectExtensions.toObject(xmlString, typeReference, XmlMapperFactory.newXmlMapper());
    }

    public static <T> T toObject(String xmlString, JavaType javaType) throws JsonProcessingException {
        Objects.requireNonNull(xmlString);
        Objects.requireNonNull(javaType);
        return XmlToObjectExtensions.toObject(xmlString, javaType, XmlMapperFactory.newXmlMapper());
    }

    public static <T> T toObject(String xmlString, TypeReference<T> typeReference, XmlMapper xmlMapper) throws JsonProcessingException {
        Objects.requireNonNull(xmlString);
        Objects.requireNonNull(typeReference);
        Objects.requireNonNull(xmlMapper);
        return (T)xmlMapper.readValue(xmlString, typeReference);
    }

    public static <T> T toObject(String xmlString, JavaType javaType, XmlMapper xmlMapper) throws JsonProcessingException {
        Objects.requireNonNull(xmlString);
        Objects.requireNonNull(javaType);
        Objects.requireNonNull(xmlMapper);
        return (T)xmlMapper.readValue(xmlString, javaType);
    }
}

