/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.xstream;

import com.thoughtworks.xstream.XStream;
import io.github.astrapi69.file.write.WriteFileExtensions;
import io.github.astrapi69.throwable.RuntimeExceptionDecorator;
import io.github.astrapi69.xstream.factory.XStreamFactory;
import java.io.File;
import java.util.Map;
import lombok.NonNull;

public class ObjectToXmlFileExtensions {
    public static <T> void toXml(@NonNull T object, @NonNull File file) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        ObjectToXmlFileExtensions.toXml(null, object, file);
    }

    public static <T> void toXml(XStream xstream, @NonNull T objectToXML, @NonNull File file) {
        if (objectToXML == null) {
            throw new NullPointerException("objectToXML is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        ObjectToXmlFileExtensions.toXml(xstream, objectToXML, null, file);
    }

    public static <T> void toXml(XStream xstream, @NonNull T objectToXML, Map<String, Class<?>> aliases, @NonNull File file) {
        if (objectToXML == null) {
            throw new NullPointerException("objectToXML is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        RuntimeExceptionDecorator.decorate(() -> WriteFileExtensions.string2File((File)file, (String)XStreamFactory.initializeXStream(xstream, aliases).toXML(objectToXML), (String)"UTF-8"));
    }

    public static <T> void toXml(@NonNull T objectToXML, Map<String, Class<?>> aliases, @NonNull File file) {
        if (objectToXML == null) {
            throw new NullPointerException("objectToXML is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        ObjectToXmlFileExtensions.toXml(null, objectToXML, aliases, file);
    }
}

