/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.xstream;

import com.thoughtworks.xstream.XStream;
import io.github.astrapi69.file.read.ReadFileExtensions;
import io.github.astrapi69.throwable.RuntimeExceptionDecorator;
import io.github.astrapi69.xstream.XmlToObjectExtensions;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Objects;

public final class XmlFileToObjectExtensions {
    private XmlFileToObjectExtensions() {
    }

    public static <T> T toObject(File xmlFile) {
        Objects.requireNonNull(xmlFile);
        return XmlToObjectExtensions.toObject(null, (String)RuntimeExceptionDecorator.decorate(() -> ReadFileExtensions.readFromFile((File)xmlFile)));
    }

    public static <T> T toObject(File xmlFile, Map<String, Class<?>> aliases) {
        Objects.requireNonNull(xmlFile);
        return XmlToObjectExtensions.toObject(null, (String)RuntimeExceptionDecorator.decorate(() -> ReadFileExtensions.readFromFile((File)xmlFile)), aliases);
    }

    public static <T> T toObject(XStream xstream, File xmlFile) {
        Objects.requireNonNull(xmlFile);
        return XmlToObjectExtensions.toObject(xstream, (String)RuntimeExceptionDecorator.decorate(() -> ReadFileExtensions.readFromFile((File)xmlFile)), null);
    }

    public static <T> T toObject(XStream xstream, File xmlFile, Map<String, Class<?>> aliases) {
        Objects.requireNonNull(xmlFile);
        return XmlToObjectExtensions.toObject(xstream, (String)RuntimeExceptionDecorator.decorate(() -> ReadFileExtensions.readFromFile((File)xmlFile)), aliases);
    }

    public static <T> T toObject(XStream xstream, File xmlFile, String charsetName, Map<String, Class<?>> aliases) {
        Objects.requireNonNull(xmlFile);
        return XmlToObjectExtensions.toObject(xstream, (String)RuntimeExceptionDecorator.decorate(() -> ReadFileExtensions.readFromFile((File)xmlFile, (Charset)Charset.forName(charsetName))), aliases);
    }
}

