/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.xstream;

import com.thoughtworks.xstream.XStream;
import io.github.astrapi69.xstream.factory.XStreamFactory;
import java.util.Map;
import java.util.Objects;

public final class XmlToObjectExtensions {
    private XmlToObjectExtensions() {
    }

    public static <T> T toObject(String xmlString) {
        return XmlToObjectExtensions.toObject(null, xmlString);
    }

    public static <T> T toObject(String xmlString, Map<String, Class<?>> aliases) {
        return XmlToObjectExtensions.toObject(null, xmlString, aliases);
    }

    public static <T> T toObject(XStream xstream, String xmlString) {
        return XmlToObjectExtensions.toObject(xstream, xmlString, null);
    }

    public static <T> T toObject(XStream xstream, String xmlString, Map<String, Class<?>> aliases) {
        Objects.requireNonNull(xmlString);
        xstream = XStreamFactory.initializeXStream(xstream, aliases);
        return (T)xstream.fromXML(xmlString);
    }
}

