/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.xstream.factory;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.security.TypePermission;
import com.thoughtworks.xstream.security.WildcardTypePermission;
import java.util.Map;

public final class XStreamFactory {
    private XStreamFactory() {
    }

    public static XStream initializeXStream(XStream xstream, Map<String, Class<?>> aliases) {
        if (xstream == null) {
            xstream = XStreamFactory.newXStream();
        }
        if (aliases != null) {
            for (Map.Entry<String, Class<?>> alias : aliases.entrySet()) {
                xstream.alias(alias.getKey(), alias.getValue());
            }
        }
        xstream.allowTypesByWildcard(new String[]{"io.github.astrapi69.**"});
        return xstream;
    }

    public static XStream newXStream() {
        return new XStream();
    }

    public static XStream newXStream(HierarchicalStreamDriver hierarchicalStreamDriver) {
        return new XStream(hierarchicalStreamDriver);
    }

    public static XStream newXStream(XStream xstream, Map<String, Class<?>> aliases, String ... allowTypesByWildcard) {
        if (0 < allowTypesByWildcard.length) {
            xstream.addPermission((TypePermission)new WildcardTypePermission(allowTypesByWildcard));
        }
        XStreamFactory.initializeXStream(xstream, aliases);
        return xstream;
    }
}

