/*
 * Decompiled with CFR 0.152.
 */
package io.github.atkawa7.har;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.github.atkawa7.har.HarCache;
import io.github.atkawa7.har.HarRequest;
import io.github.atkawa7.har.HarResponse;
import io.github.atkawa7.har.HarTimings;

@JsonPropertyOrder(value={"pageref", "startedDateTime", "time", "request", "response", "cache", "timings", "serverIPAddress", "connection", "comment"})
public class HarEntry {
    private String pageref;
    private String startedDateTime;
    private long time;
    private HarRequest request;
    private HarResponse response;
    private HarCache cache;
    private HarTimings timings;
    private String serverIPAddress;
    private String connection;
    private String comment;

    public HarEntry(String pageref, String startedDateTime, long time, HarRequest request, HarResponse response, HarCache cache, HarTimings timings, String serverIPAddress, String connection, String comment) {
        this.pageref = pageref;
        this.startedDateTime = startedDateTime;
        this.time = time;
        this.request = request;
        this.response = response;
        this.cache = cache;
        this.timings = timings;
        this.serverIPAddress = serverIPAddress;
        this.connection = connection;
        this.comment = comment;
    }

    public HarEntry() {
    }

    public static HarEntryBuilder builder() {
        return new HarEntryBuilder();
    }

    public String getPageref() {
        return this.pageref;
    }

    public String getStartedDateTime() {
        return this.startedDateTime;
    }

    public long getTime() {
        return this.time;
    }

    public HarRequest getRequest() {
        return this.request;
    }

    public HarResponse getResponse() {
        return this.response;
    }

    public HarCache getCache() {
        return this.cache;
    }

    public HarTimings getTimings() {
        return this.timings;
    }

    public String getServerIPAddress() {
        return this.serverIPAddress;
    }

    public String getConnection() {
        return this.connection;
    }

    public String getComment() {
        return this.comment;
    }

    public void setPageref(String pageref) {
        this.pageref = pageref;
    }

    public void setStartedDateTime(String startedDateTime) {
        this.startedDateTime = startedDateTime;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public void setRequest(HarRequest request) {
        this.request = request;
    }

    public void setResponse(HarResponse response) {
        this.response = response;
    }

    public void setCache(HarCache cache) {
        this.cache = cache;
    }

    public void setTimings(HarTimings timings) {
        this.timings = timings;
    }

    public void setServerIPAddress(String serverIPAddress) {
        this.serverIPAddress = serverIPAddress;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HarEntry)) {
            return false;
        }
        HarEntry other = (HarEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$pageref = this.getPageref();
        String other$pageref = other.getPageref();
        if (this$pageref == null ? other$pageref != null : !this$pageref.equals(other$pageref)) {
            return false;
        }
        String this$startedDateTime = this.getStartedDateTime();
        String other$startedDateTime = other.getStartedDateTime();
        if (this$startedDateTime == null ? other$startedDateTime != null : !this$startedDateTime.equals(other$startedDateTime)) {
            return false;
        }
        if (this.getTime() != other.getTime()) {
            return false;
        }
        HarRequest this$request = this.getRequest();
        HarRequest other$request = other.getRequest();
        if (this$request == null ? other$request != null : !((Object)this$request).equals(other$request)) {
            return false;
        }
        HarResponse this$response = this.getResponse();
        HarResponse other$response = other.getResponse();
        if (this$response == null ? other$response != null : !((Object)this$response).equals(other$response)) {
            return false;
        }
        HarCache this$cache = this.getCache();
        HarCache other$cache = other.getCache();
        if (this$cache == null ? other$cache != null : !((Object)this$cache).equals(other$cache)) {
            return false;
        }
        HarTimings this$timings = this.getTimings();
        HarTimings other$timings = other.getTimings();
        if (this$timings == null ? other$timings != null : !((Object)this$timings).equals(other$timings)) {
            return false;
        }
        String this$serverIPAddress = this.getServerIPAddress();
        String other$serverIPAddress = other.getServerIPAddress();
        if (this$serverIPAddress == null ? other$serverIPAddress != null : !this$serverIPAddress.equals(other$serverIPAddress)) {
            return false;
        }
        String this$connection = this.getConnection();
        String other$connection = other.getConnection();
        if (this$connection == null ? other$connection != null : !this$connection.equals(other$connection)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        return !(this$comment == null ? other$comment != null : !this$comment.equals(other$comment));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HarEntry;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $pageref = this.getPageref();
        result = result * 59 + ($pageref == null ? 43 : $pageref.hashCode());
        String $startedDateTime = this.getStartedDateTime();
        result = result * 59 + ($startedDateTime == null ? 43 : $startedDateTime.hashCode());
        long $time = this.getTime();
        result = result * 59 + (int)($time >>> 32 ^ $time);
        HarRequest $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
        HarResponse $response = this.getResponse();
        result = result * 59 + ($response == null ? 43 : ((Object)$response).hashCode());
        HarCache $cache = this.getCache();
        result = result * 59 + ($cache == null ? 43 : ((Object)$cache).hashCode());
        HarTimings $timings = this.getTimings();
        result = result * 59 + ($timings == null ? 43 : ((Object)$timings).hashCode());
        String $serverIPAddress = this.getServerIPAddress();
        result = result * 59 + ($serverIPAddress == null ? 43 : $serverIPAddress.hashCode());
        String $connection = this.getConnection();
        result = result * 59 + ($connection == null ? 43 : $connection.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        return result;
    }

    public String toString() {
        return "HarEntry(pageref=" + this.getPageref() + ", startedDateTime=" + this.getStartedDateTime() + ", time=" + this.getTime() + ", request=" + this.getRequest() + ", response=" + this.getResponse() + ", cache=" + this.getCache() + ", timings=" + this.getTimings() + ", serverIPAddress=" + this.getServerIPAddress() + ", connection=" + this.getConnection() + ", comment=" + this.getComment() + ")";
    }

    public HarEntry withPageref(String pageref) {
        return this.pageref == pageref ? this : new HarEntry(pageref, this.startedDateTime, this.time, this.request, this.response, this.cache, this.timings, this.serverIPAddress, this.connection, this.comment);
    }

    public HarEntry withStartedDateTime(String startedDateTime) {
        return this.startedDateTime == startedDateTime ? this : new HarEntry(this.pageref, startedDateTime, this.time, this.request, this.response, this.cache, this.timings, this.serverIPAddress, this.connection, this.comment);
    }

    public HarEntry withTime(long time) {
        return this.time == time ? this : new HarEntry(this.pageref, this.startedDateTime, time, this.request, this.response, this.cache, this.timings, this.serverIPAddress, this.connection, this.comment);
    }

    public HarEntry withRequest(HarRequest request) {
        return this.request == request ? this : new HarEntry(this.pageref, this.startedDateTime, this.time, request, this.response, this.cache, this.timings, this.serverIPAddress, this.connection, this.comment);
    }

    public HarEntry withResponse(HarResponse response) {
        return this.response == response ? this : new HarEntry(this.pageref, this.startedDateTime, this.time, this.request, response, this.cache, this.timings, this.serverIPAddress, this.connection, this.comment);
    }

    public HarEntry withCache(HarCache cache) {
        return this.cache == cache ? this : new HarEntry(this.pageref, this.startedDateTime, this.time, this.request, this.response, cache, this.timings, this.serverIPAddress, this.connection, this.comment);
    }

    public HarEntry withTimings(HarTimings timings) {
        return this.timings == timings ? this : new HarEntry(this.pageref, this.startedDateTime, this.time, this.request, this.response, this.cache, timings, this.serverIPAddress, this.connection, this.comment);
    }

    public HarEntry withServerIPAddress(String serverIPAddress) {
        return this.serverIPAddress == serverIPAddress ? this : new HarEntry(this.pageref, this.startedDateTime, this.time, this.request, this.response, this.cache, this.timings, serverIPAddress, this.connection, this.comment);
    }

    public HarEntry withConnection(String connection) {
        return this.connection == connection ? this : new HarEntry(this.pageref, this.startedDateTime, this.time, this.request, this.response, this.cache, this.timings, this.serverIPAddress, connection, this.comment);
    }

    public HarEntry withComment(String comment) {
        return this.comment == comment ? this : new HarEntry(this.pageref, this.startedDateTime, this.time, this.request, this.response, this.cache, this.timings, this.serverIPAddress, this.connection, comment);
    }

    public static class HarEntryBuilder {
        private String pageref;
        private String startedDateTime;
        private long time;
        private HarRequest request;
        private HarResponse response;
        private HarCache cache;
        private HarTimings timings;
        private String serverIPAddress;
        private String connection;
        private String comment;

        HarEntryBuilder() {
        }

        public HarEntryBuilder pageref(String pageref) {
            this.pageref = pageref;
            return this;
        }

        public HarEntryBuilder startedDateTime(String startedDateTime) {
            this.startedDateTime = startedDateTime;
            return this;
        }

        public HarEntryBuilder time(long time) {
            this.time = time;
            return this;
        }

        public HarEntryBuilder request(HarRequest request) {
            this.request = request;
            return this;
        }

        public HarEntryBuilder response(HarResponse response) {
            this.response = response;
            return this;
        }

        public HarEntryBuilder cache(HarCache cache) {
            this.cache = cache;
            return this;
        }

        public HarEntryBuilder timings(HarTimings timings) {
            this.timings = timings;
            return this;
        }

        public HarEntryBuilder serverIPAddress(String serverIPAddress) {
            this.serverIPAddress = serverIPAddress;
            return this;
        }

        public HarEntryBuilder connection(String connection) {
            this.connection = connection;
            return this;
        }

        public HarEntryBuilder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public HarEntry build() {
            return new HarEntry(this.pageref, this.startedDateTime, this.time, this.request, this.response, this.cache, this.timings, this.serverIPAddress, this.connection, this.comment);
        }

        public String toString() {
            return "HarEntry.HarEntryBuilder(pageref=" + this.pageref + ", startedDateTime=" + this.startedDateTime + ", time=" + this.time + ", request=" + this.request + ", response=" + this.response + ", cache=" + this.cache + ", timings=" + this.timings + ", serverIPAddress=" + this.serverIPAddress + ", connection=" + this.connection + ", comment=" + this.comment + ")";
        }
    }
}

