/*
 * Decompiled with CFR 0.152.
 */
package io.github.atkawa7.har;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.github.atkawa7.har.HarBrowser;
import io.github.atkawa7.har.HarCreator;
import io.github.atkawa7.har.HarEntry;
import io.github.atkawa7.har.HarPage;
import java.util.List;

@JsonPropertyOrder(value={"version", "creator", "browser", "pages", "entries", "comment"})
public class HarLog {
    private String version = "1.2";
    private HarCreator creator;
    private HarBrowser browser;
    private List<HarPage> pages;
    private List<HarEntry> entries;
    private String comment;

    public HarLog(String version, HarCreator creator, HarBrowser browser, List<HarPage> pages, List<HarEntry> entries, String comment) {
        this.version = version;
        this.creator = creator;
        this.browser = browser;
        this.pages = pages;
        this.entries = entries;
        this.comment = comment;
    }

    public HarLog() {
    }

    public static HarLogBuilder builder() {
        return new HarLogBuilder();
    }

    public String getVersion() {
        return this.version;
    }

    public HarCreator getCreator() {
        return this.creator;
    }

    public HarBrowser getBrowser() {
        return this.browser;
    }

    public List<HarPage> getPages() {
        return this.pages;
    }

    public List<HarEntry> getEntries() {
        return this.entries;
    }

    public String getComment() {
        return this.comment;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setCreator(HarCreator creator) {
        this.creator = creator;
    }

    public void setBrowser(HarBrowser browser) {
        this.browser = browser;
    }

    public void setPages(List<HarPage> pages) {
        this.pages = pages;
    }

    public void setEntries(List<HarEntry> entries) {
        this.entries = entries;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HarLog)) {
            return false;
        }
        HarLog other = (HarLog)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        HarCreator this$creator = this.getCreator();
        HarCreator other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !((Object)this$creator).equals(other$creator)) {
            return false;
        }
        HarBrowser this$browser = this.getBrowser();
        HarBrowser other$browser = other.getBrowser();
        if (this$browser == null ? other$browser != null : !((Object)this$browser).equals(other$browser)) {
            return false;
        }
        List<HarPage> this$pages = this.getPages();
        List<HarPage> other$pages = other.getPages();
        if (this$pages == null ? other$pages != null : !((Object)this$pages).equals(other$pages)) {
            return false;
        }
        List<HarEntry> this$entries = this.getEntries();
        List<HarEntry> other$entries = other.getEntries();
        if (this$entries == null ? other$entries != null : !((Object)this$entries).equals(other$entries)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        return !(this$comment == null ? other$comment != null : !this$comment.equals(other$comment));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HarLog;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        HarCreator $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : ((Object)$creator).hashCode());
        HarBrowser $browser = this.getBrowser();
        result = result * 59 + ($browser == null ? 43 : ((Object)$browser).hashCode());
        List<HarPage> $pages = this.getPages();
        result = result * 59 + ($pages == null ? 43 : ((Object)$pages).hashCode());
        List<HarEntry> $entries = this.getEntries();
        result = result * 59 + ($entries == null ? 43 : ((Object)$entries).hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        return result;
    }

    public String toString() {
        return "HarLog(version=" + this.getVersion() + ", creator=" + this.getCreator() + ", browser=" + this.getBrowser() + ", pages=" + this.getPages() + ", entries=" + this.getEntries() + ", comment=" + this.getComment() + ")";
    }

    public HarLog withVersion(String version) {
        return this.version == version ? this : new HarLog(version, this.creator, this.browser, this.pages, this.entries, this.comment);
    }

    public HarLog withCreator(HarCreator creator) {
        return this.creator == creator ? this : new HarLog(this.version, creator, this.browser, this.pages, this.entries, this.comment);
    }

    public HarLog withBrowser(HarBrowser browser) {
        return this.browser == browser ? this : new HarLog(this.version, this.creator, browser, this.pages, this.entries, this.comment);
    }

    public HarLog withPages(List<HarPage> pages) {
        return this.pages == pages ? this : new HarLog(this.version, this.creator, this.browser, pages, this.entries, this.comment);
    }

    public HarLog withEntries(List<HarEntry> entries) {
        return this.entries == entries ? this : new HarLog(this.version, this.creator, this.browser, this.pages, entries, this.comment);
    }

    public HarLog withComment(String comment) {
        return this.comment == comment ? this : new HarLog(this.version, this.creator, this.browser, this.pages, this.entries, comment);
    }

    public static class HarLogBuilder {
        private String version;
        private HarCreator creator;
        private HarBrowser browser;
        private List<HarPage> pages;
        private List<HarEntry> entries;
        private String comment;

        HarLogBuilder() {
        }

        public HarLogBuilder version(String version) {
            this.version = version;
            return this;
        }

        public HarLogBuilder creator(HarCreator creator) {
            this.creator = creator;
            return this;
        }

        public HarLogBuilder browser(HarBrowser browser) {
            this.browser = browser;
            return this;
        }

        public HarLogBuilder pages(List<HarPage> pages) {
            this.pages = pages;
            return this;
        }

        public HarLogBuilder entries(List<HarEntry> entries) {
            this.entries = entries;
            return this;
        }

        public HarLogBuilder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public HarLog build() {
            return new HarLog(this.version, this.creator, this.browser, this.pages, this.entries, this.comment);
        }

        public String toString() {
            return "HarLog.HarLogBuilder(version=" + this.version + ", creator=" + this.creator + ", browser=" + this.browser + ", pages=" + this.pages + ", entries=" + this.entries + ", comment=" + this.comment + ")";
        }
    }
}

