/*
 * Decompiled with CFR 0.152.
 */
package io.github.atkawa7.har;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.github.atkawa7.har.HarCookie;
import io.github.atkawa7.har.HarHeader;
import io.github.atkawa7.har.HarPostData;
import io.github.atkawa7.har.HarQueryString;
import java.util.List;

@JsonPropertyOrder(value={"method", "url", "httpVersion", "cookies", "headers", "queryString", "postData", "headersSize", "bodySize", "comment"})
public class HarRequest {
    private String url;
    private String httpVersion;
    private List<HarCookie> cookies;
    private List<HarHeader> headers;
    private List<HarQueryString> queryString;
    private HarPostData postData;
    private Long headersSize;
    private Long bodySize;
    private String comment;
    private String method;

    public HarRequest(String url, String httpVersion, List<HarCookie> cookies, List<HarHeader> headers, List<HarQueryString> queryString, HarPostData postData, Long headersSize, Long bodySize, String comment, String method) {
        this.url = url;
        this.httpVersion = httpVersion;
        this.cookies = cookies;
        this.headers = headers;
        this.queryString = queryString;
        this.postData = postData;
        this.headersSize = headersSize;
        this.bodySize = bodySize;
        this.comment = comment;
        this.method = method;
    }

    public HarRequest() {
    }

    public static HarRequestBuilder builder() {
        return new HarRequestBuilder();
    }

    public String getUrl() {
        return this.url;
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    public List<HarCookie> getCookies() {
        return this.cookies;
    }

    public List<HarHeader> getHeaders() {
        return this.headers;
    }

    public List<HarQueryString> getQueryString() {
        return this.queryString;
    }

    public HarPostData getPostData() {
        return this.postData;
    }

    public Long getHeadersSize() {
        return this.headersSize;
    }

    public Long getBodySize() {
        return this.bodySize;
    }

    public String getComment() {
        return this.comment;
    }

    public String getMethod() {
        return this.method;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setHttpVersion(String httpVersion) {
        this.httpVersion = httpVersion;
    }

    public void setCookies(List<HarCookie> cookies) {
        this.cookies = cookies;
    }

    public void setHeaders(List<HarHeader> headers) {
        this.headers = headers;
    }

    public void setQueryString(List<HarQueryString> queryString) {
        this.queryString = queryString;
    }

    public void setPostData(HarPostData postData) {
        this.postData = postData;
    }

    public void setHeadersSize(Long headersSize) {
        this.headersSize = headersSize;
    }

    public void setBodySize(Long bodySize) {
        this.bodySize = bodySize;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HarRequest)) {
            return false;
        }
        HarRequest other = (HarRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$httpVersion = this.getHttpVersion();
        String other$httpVersion = other.getHttpVersion();
        if (this$httpVersion == null ? other$httpVersion != null : !this$httpVersion.equals(other$httpVersion)) {
            return false;
        }
        List<HarCookie> this$cookies = this.getCookies();
        List<HarCookie> other$cookies = other.getCookies();
        if (this$cookies == null ? other$cookies != null : !((Object)this$cookies).equals(other$cookies)) {
            return false;
        }
        List<HarHeader> this$headers = this.getHeaders();
        List<HarHeader> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        List<HarQueryString> this$queryString = this.getQueryString();
        List<HarQueryString> other$queryString = other.getQueryString();
        if (this$queryString == null ? other$queryString != null : !((Object)this$queryString).equals(other$queryString)) {
            return false;
        }
        HarPostData this$postData = this.getPostData();
        HarPostData other$postData = other.getPostData();
        if (this$postData == null ? other$postData != null : !((Object)this$postData).equals(other$postData)) {
            return false;
        }
        Long this$headersSize = this.getHeadersSize();
        Long other$headersSize = other.getHeadersSize();
        if (this$headersSize == null ? other$headersSize != null : !((Object)this$headersSize).equals(other$headersSize)) {
            return false;
        }
        Long this$bodySize = this.getBodySize();
        Long other$bodySize = other.getBodySize();
        if (this$bodySize == null ? other$bodySize != null : !((Object)this$bodySize).equals(other$bodySize)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        return !(this$method == null ? other$method != null : !this$method.equals(other$method));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HarRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $httpVersion = this.getHttpVersion();
        result = result * 59 + ($httpVersion == null ? 43 : $httpVersion.hashCode());
        List<HarCookie> $cookies = this.getCookies();
        result = result * 59 + ($cookies == null ? 43 : ((Object)$cookies).hashCode());
        List<HarHeader> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        List<HarQueryString> $queryString = this.getQueryString();
        result = result * 59 + ($queryString == null ? 43 : ((Object)$queryString).hashCode());
        HarPostData $postData = this.getPostData();
        result = result * 59 + ($postData == null ? 43 : ((Object)$postData).hashCode());
        Long $headersSize = this.getHeadersSize();
        result = result * 59 + ($headersSize == null ? 43 : ((Object)$headersSize).hashCode());
        Long $bodySize = this.getBodySize();
        result = result * 59 + ($bodySize == null ? 43 : ((Object)$bodySize).hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        return result;
    }

    public String toString() {
        return "HarRequest(url=" + this.getUrl() + ", httpVersion=" + this.getHttpVersion() + ", cookies=" + this.getCookies() + ", headers=" + this.getHeaders() + ", queryString=" + this.getQueryString() + ", postData=" + this.getPostData() + ", headersSize=" + this.getHeadersSize() + ", bodySize=" + this.getBodySize() + ", comment=" + this.getComment() + ", method=" + this.getMethod() + ")";
    }

    public HarRequest withUrl(String url) {
        return this.url == url ? this : new HarRequest(url, this.httpVersion, this.cookies, this.headers, this.queryString, this.postData, this.headersSize, this.bodySize, this.comment, this.method);
    }

    public HarRequest withHttpVersion(String httpVersion) {
        return this.httpVersion == httpVersion ? this : new HarRequest(this.url, httpVersion, this.cookies, this.headers, this.queryString, this.postData, this.headersSize, this.bodySize, this.comment, this.method);
    }

    public HarRequest withCookies(List<HarCookie> cookies) {
        return this.cookies == cookies ? this : new HarRequest(this.url, this.httpVersion, cookies, this.headers, this.queryString, this.postData, this.headersSize, this.bodySize, this.comment, this.method);
    }

    public HarRequest withHeaders(List<HarHeader> headers) {
        return this.headers == headers ? this : new HarRequest(this.url, this.httpVersion, this.cookies, headers, this.queryString, this.postData, this.headersSize, this.bodySize, this.comment, this.method);
    }

    public HarRequest withQueryString(List<HarQueryString> queryString) {
        return this.queryString == queryString ? this : new HarRequest(this.url, this.httpVersion, this.cookies, this.headers, queryString, this.postData, this.headersSize, this.bodySize, this.comment, this.method);
    }

    public HarRequest withPostData(HarPostData postData) {
        return this.postData == postData ? this : new HarRequest(this.url, this.httpVersion, this.cookies, this.headers, this.queryString, postData, this.headersSize, this.bodySize, this.comment, this.method);
    }

    public HarRequest withHeadersSize(Long headersSize) {
        return this.headersSize == headersSize ? this : new HarRequest(this.url, this.httpVersion, this.cookies, this.headers, this.queryString, this.postData, headersSize, this.bodySize, this.comment, this.method);
    }

    public HarRequest withBodySize(Long bodySize) {
        return this.bodySize == bodySize ? this : new HarRequest(this.url, this.httpVersion, this.cookies, this.headers, this.queryString, this.postData, this.headersSize, bodySize, this.comment, this.method);
    }

    public HarRequest withComment(String comment) {
        return this.comment == comment ? this : new HarRequest(this.url, this.httpVersion, this.cookies, this.headers, this.queryString, this.postData, this.headersSize, this.bodySize, comment, this.method);
    }

    public HarRequest withMethod(String method) {
        return this.method == method ? this : new HarRequest(this.url, this.httpVersion, this.cookies, this.headers, this.queryString, this.postData, this.headersSize, this.bodySize, this.comment, method);
    }

    public static class HarRequestBuilder {
        private String url;
        private String httpVersion;
        private List<HarCookie> cookies;
        private List<HarHeader> headers;
        private List<HarQueryString> queryString;
        private HarPostData postData;
        private Long headersSize;
        private Long bodySize;
        private String comment;
        private String method;

        HarRequestBuilder() {
        }

        public HarRequestBuilder url(String url) {
            this.url = url;
            return this;
        }

        public HarRequestBuilder httpVersion(String httpVersion) {
            this.httpVersion = httpVersion;
            return this;
        }

        public HarRequestBuilder cookies(List<HarCookie> cookies) {
            this.cookies = cookies;
            return this;
        }

        public HarRequestBuilder headers(List<HarHeader> headers) {
            this.headers = headers;
            return this;
        }

        public HarRequestBuilder queryString(List<HarQueryString> queryString) {
            this.queryString = queryString;
            return this;
        }

        public HarRequestBuilder postData(HarPostData postData) {
            this.postData = postData;
            return this;
        }

        public HarRequestBuilder headersSize(Long headersSize) {
            this.headersSize = headersSize;
            return this;
        }

        public HarRequestBuilder bodySize(Long bodySize) {
            this.bodySize = bodySize;
            return this;
        }

        public HarRequestBuilder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public HarRequestBuilder method(String method) {
            this.method = method;
            return this;
        }

        public HarRequest build() {
            return new HarRequest(this.url, this.httpVersion, this.cookies, this.headers, this.queryString, this.postData, this.headersSize, this.bodySize, this.comment, this.method);
        }

        public String toString() {
            return "HarRequest.HarRequestBuilder(url=" + this.url + ", httpVersion=" + this.httpVersion + ", cookies=" + this.cookies + ", headers=" + this.headers + ", queryString=" + this.queryString + ", postData=" + this.postData + ", headersSize=" + this.headersSize + ", bodySize=" + this.bodySize + ", comment=" + this.comment + ", method=" + this.method + ")";
        }
    }
}

