/*
 * Decompiled with CFR 0.152.
 */
package io.github.atkawa7.har;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.github.atkawa7.har.HarContent;
import io.github.atkawa7.har.HarCookie;
import io.github.atkawa7.har.HarHeader;
import java.util.List;

@JsonPropertyOrder(value={"status", "statusText", "httpVersion", "cookies", "headers", "content", "redirectURL", "headersSize", "bodySize", "comment"})
public class HarResponse {
    private int status;
    private String statusText;
    private String httpVersion;
    private List<HarCookie> cookies;
    private List<HarHeader> headers;
    private HarContent content;
    private String redirectURL;
    private Long headersSize;
    private Long bodySize;
    private String comment;

    public HarResponse(int status, String statusText, String httpVersion, List<HarCookie> cookies, List<HarHeader> headers, HarContent content, String redirectURL, Long headersSize, Long bodySize, String comment) {
        this.status = status;
        this.statusText = statusText;
        this.httpVersion = httpVersion;
        this.cookies = cookies;
        this.headers = headers;
        this.content = content;
        this.redirectURL = redirectURL;
        this.headersSize = headersSize;
        this.bodySize = bodySize;
        this.comment = comment;
    }

    public HarResponse() {
    }

    public static HarResponseBuilder builder() {
        return new HarResponseBuilder();
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    public List<HarCookie> getCookies() {
        return this.cookies;
    }

    public List<HarHeader> getHeaders() {
        return this.headers;
    }

    public HarContent getContent() {
        return this.content;
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public Long getHeadersSize() {
        return this.headersSize;
    }

    public Long getBodySize() {
        return this.bodySize;
    }

    public String getComment() {
        return this.comment;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setStatusText(String statusText) {
        this.statusText = statusText;
    }

    public void setHttpVersion(String httpVersion) {
        this.httpVersion = httpVersion;
    }

    public void setCookies(List<HarCookie> cookies) {
        this.cookies = cookies;
    }

    public void setHeaders(List<HarHeader> headers) {
        this.headers = headers;
    }

    public void setContent(HarContent content) {
        this.content = content;
    }

    public void setRedirectURL(String redirectURL) {
        this.redirectURL = redirectURL;
    }

    public void setHeadersSize(Long headersSize) {
        this.headersSize = headersSize;
    }

    public void setBodySize(Long bodySize) {
        this.bodySize = bodySize;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HarResponse)) {
            return false;
        }
        HarResponse other = (HarResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStatus() != other.getStatus()) {
            return false;
        }
        String this$statusText = this.getStatusText();
        String other$statusText = other.getStatusText();
        if (this$statusText == null ? other$statusText != null : !this$statusText.equals(other$statusText)) {
            return false;
        }
        String this$httpVersion = this.getHttpVersion();
        String other$httpVersion = other.getHttpVersion();
        if (this$httpVersion == null ? other$httpVersion != null : !this$httpVersion.equals(other$httpVersion)) {
            return false;
        }
        List<HarCookie> this$cookies = this.getCookies();
        List<HarCookie> other$cookies = other.getCookies();
        if (this$cookies == null ? other$cookies != null : !((Object)this$cookies).equals(other$cookies)) {
            return false;
        }
        List<HarHeader> this$headers = this.getHeaders();
        List<HarHeader> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        HarContent this$content = this.getContent();
        HarContent other$content = other.getContent();
        if (this$content == null ? other$content != null : !((Object)this$content).equals(other$content)) {
            return false;
        }
        String this$redirectURL = this.getRedirectURL();
        String other$redirectURL = other.getRedirectURL();
        if (this$redirectURL == null ? other$redirectURL != null : !this$redirectURL.equals(other$redirectURL)) {
            return false;
        }
        Long this$headersSize = this.getHeadersSize();
        Long other$headersSize = other.getHeadersSize();
        if (this$headersSize == null ? other$headersSize != null : !((Object)this$headersSize).equals(other$headersSize)) {
            return false;
        }
        Long this$bodySize = this.getBodySize();
        Long other$bodySize = other.getBodySize();
        if (this$bodySize == null ? other$bodySize != null : !((Object)this$bodySize).equals(other$bodySize)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        return !(this$comment == null ? other$comment != null : !this$comment.equals(other$comment));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HarResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStatus();
        String $statusText = this.getStatusText();
        result = result * 59 + ($statusText == null ? 43 : $statusText.hashCode());
        String $httpVersion = this.getHttpVersion();
        result = result * 59 + ($httpVersion == null ? 43 : $httpVersion.hashCode());
        List<HarCookie> $cookies = this.getCookies();
        result = result * 59 + ($cookies == null ? 43 : ((Object)$cookies).hashCode());
        List<HarHeader> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        HarContent $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
        String $redirectURL = this.getRedirectURL();
        result = result * 59 + ($redirectURL == null ? 43 : $redirectURL.hashCode());
        Long $headersSize = this.getHeadersSize();
        result = result * 59 + ($headersSize == null ? 43 : ((Object)$headersSize).hashCode());
        Long $bodySize = this.getBodySize();
        result = result * 59 + ($bodySize == null ? 43 : ((Object)$bodySize).hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        return result;
    }

    public String toString() {
        return "HarResponse(status=" + this.getStatus() + ", statusText=" + this.getStatusText() + ", httpVersion=" + this.getHttpVersion() + ", cookies=" + this.getCookies() + ", headers=" + this.getHeaders() + ", content=" + this.getContent() + ", redirectURL=" + this.getRedirectURL() + ", headersSize=" + this.getHeadersSize() + ", bodySize=" + this.getBodySize() + ", comment=" + this.getComment() + ")";
    }

    public HarResponse withStatus(int status) {
        return this.status == status ? this : new HarResponse(status, this.statusText, this.httpVersion, this.cookies, this.headers, this.content, this.redirectURL, this.headersSize, this.bodySize, this.comment);
    }

    public HarResponse withStatusText(String statusText) {
        return this.statusText == statusText ? this : new HarResponse(this.status, statusText, this.httpVersion, this.cookies, this.headers, this.content, this.redirectURL, this.headersSize, this.bodySize, this.comment);
    }

    public HarResponse withHttpVersion(String httpVersion) {
        return this.httpVersion == httpVersion ? this : new HarResponse(this.status, this.statusText, httpVersion, this.cookies, this.headers, this.content, this.redirectURL, this.headersSize, this.bodySize, this.comment);
    }

    public HarResponse withCookies(List<HarCookie> cookies) {
        return this.cookies == cookies ? this : new HarResponse(this.status, this.statusText, this.httpVersion, cookies, this.headers, this.content, this.redirectURL, this.headersSize, this.bodySize, this.comment);
    }

    public HarResponse withHeaders(List<HarHeader> headers) {
        return this.headers == headers ? this : new HarResponse(this.status, this.statusText, this.httpVersion, this.cookies, headers, this.content, this.redirectURL, this.headersSize, this.bodySize, this.comment);
    }

    public HarResponse withContent(HarContent content) {
        return this.content == content ? this : new HarResponse(this.status, this.statusText, this.httpVersion, this.cookies, this.headers, content, this.redirectURL, this.headersSize, this.bodySize, this.comment);
    }

    public HarResponse withRedirectURL(String redirectURL) {
        return this.redirectURL == redirectURL ? this : new HarResponse(this.status, this.statusText, this.httpVersion, this.cookies, this.headers, this.content, redirectURL, this.headersSize, this.bodySize, this.comment);
    }

    public HarResponse withHeadersSize(Long headersSize) {
        return this.headersSize == headersSize ? this : new HarResponse(this.status, this.statusText, this.httpVersion, this.cookies, this.headers, this.content, this.redirectURL, headersSize, this.bodySize, this.comment);
    }

    public HarResponse withBodySize(Long bodySize) {
        return this.bodySize == bodySize ? this : new HarResponse(this.status, this.statusText, this.httpVersion, this.cookies, this.headers, this.content, this.redirectURL, this.headersSize, bodySize, this.comment);
    }

    public HarResponse withComment(String comment) {
        return this.comment == comment ? this : new HarResponse(this.status, this.statusText, this.httpVersion, this.cookies, this.headers, this.content, this.redirectURL, this.headersSize, this.bodySize, comment);
    }

    public static class HarResponseBuilder {
        private int status;
        private String statusText;
        private String httpVersion;
        private List<HarCookie> cookies;
        private List<HarHeader> headers;
        private HarContent content;
        private String redirectURL;
        private Long headersSize;
        private Long bodySize;
        private String comment;

        HarResponseBuilder() {
        }

        public HarResponseBuilder status(int status) {
            this.status = status;
            return this;
        }

        public HarResponseBuilder statusText(String statusText) {
            this.statusText = statusText;
            return this;
        }

        public HarResponseBuilder httpVersion(String httpVersion) {
            this.httpVersion = httpVersion;
            return this;
        }

        public HarResponseBuilder cookies(List<HarCookie> cookies) {
            this.cookies = cookies;
            return this;
        }

        public HarResponseBuilder headers(List<HarHeader> headers) {
            this.headers = headers;
            return this;
        }

        public HarResponseBuilder content(HarContent content) {
            this.content = content;
            return this;
        }

        public HarResponseBuilder redirectURL(String redirectURL) {
            this.redirectURL = redirectURL;
            return this;
        }

        public HarResponseBuilder headersSize(Long headersSize) {
            this.headersSize = headersSize;
            return this;
        }

        public HarResponseBuilder bodySize(Long bodySize) {
            this.bodySize = bodySize;
            return this;
        }

        public HarResponseBuilder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public HarResponse build() {
            return new HarResponse(this.status, this.statusText, this.httpVersion, this.cookies, this.headers, this.content, this.redirectURL, this.headersSize, this.bodySize, this.comment);
        }

        public String toString() {
            return "HarResponse.HarResponseBuilder(status=" + this.status + ", statusText=" + this.statusText + ", httpVersion=" + this.httpVersion + ", cookies=" + this.cookies + ", headers=" + this.headers + ", content=" + this.content + ", redirectURL=" + this.redirectURL + ", headersSize=" + this.headersSize + ", bodySize=" + this.bodySize + ", comment=" + this.comment + ")";
        }
    }
}

