/*
 * Decompiled with CFR 0.152.
 */
package autoparams.lombok;

import autoparams.ObjectQuery;
import autoparams.ParameterQuery;
import autoparams.ResolutionContext;
import autoparams.generator.ObjectContainer;
import autoparams.generator.ObjectGenerator;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Optional;

class BuilderInvoker
implements ObjectGenerator {
    private final String builderMethodName;
    private final String buildMethodName;

    public BuilderInvoker(String builderMethodName, String buildMethodName) {
        this.builderMethodName = builderMethodName;
        this.buildMethodName = buildMethodName;
    }

    public ObjectContainer generate(ObjectQuery query, ResolutionContext context) {
        return this.getBuilder(query.getType()).map(builder -> this.factory(builder, context)).map(ObjectContainer::new).orElse(ObjectContainer.EMPTY);
    }

    private Optional<Object> getBuilder(Type type) {
        return type instanceof Class ? this.getBuilder((Class)type) : Optional.empty();
    }

    private Optional<Object> getBuilder(Class<?> type) {
        return Arrays.stream(type.getDeclaredMethods()).filter(method -> method.getName().equals(this.builderMethodName)).filter(method -> Modifier.isStatic(method.getModifiers())).map(method -> BuilderInvoker.invoke(null, method, new Object[0])).findFirst();
    }

    private Object factory(Object builder, ResolutionContext context) {
        BuilderInvoker.setProperties(builder, context);
        return this.buildObject(builder);
    }

    private static void setProperties(Object builder, ResolutionContext context) {
        Arrays.stream(builder.getClass().getDeclaredMethods()).filter(method -> method.getParameterCount() == 1).forEach(setter -> BuilderInvoker.setProperty(builder, setter, context));
    }

    private static void setProperty(Object builder, Method setter, ResolutionContext context) {
        ParameterQuery query = new ParameterQuery(setter.getParameters()[0], 0, setter.getGenericParameterTypes()[0]);
        Object argument = context.resolve((ObjectQuery)query);
        BuilderInvoker.invoke(builder, setter, argument);
    }

    private Object buildObject(Object builder) {
        try {
            Method build = builder.getClass().getMethod(this.buildMethodName, new Class[0]);
            return BuilderInvoker.invoke(builder, build, new Object[0]);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            throw new RuntimeException(exception);
        }
    }

    private static Object invoke(Object obj, Method method, Object ... args) {
        try {
            return method.invoke(obj, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            throw new RuntimeException(exception);
        }
    }
}

