/*
 * Decompiled with CFR 0.152.
 */
package autoparams.mockito;

import autoparams.customization.Customizer;
import autoparams.generator.ObjectContainer;
import autoparams.generator.ObjectGenerator;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public final class MockitoCustomizer
implements Customizer {
    public ObjectGenerator customize(ObjectGenerator generator) {
        return (query, context) -> generator.generate(query, context).yieldIfEmpty(() -> this.generate(query.getType()));
    }

    private ObjectContainer generate(Type type) {
        return type instanceof Class ? this.generate((Class)type) : (type instanceof ParameterizedType ? this.generate((ParameterizedType)type) : ObjectContainer.EMPTY);
    }

    private ObjectContainer generate(Class<?> type) {
        return new ObjectContainer(Mockito.mock(type, (Answer)Mockito.CALLS_REAL_METHODS));
    }

    private ObjectContainer generate(ParameterizedType parameterizedType) {
        Type type = parameterizedType.getRawType();
        return type instanceof Class ? this.generate((Class)type) : ObjectContainer.EMPTY;
    }
}

