/*
 * Decompiled with CFR 0.152.
 */
package com.ayvytr.flow;

import android.content.Context;
import android.content.res.Resources;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.LayoutRes;
import androidx.annotation.StringRes;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.ayvytr.flow.BaseConfig;
import com.ayvytr.flow.base.IView;
import com.ayvytr.flow.vm.BaseViewModel;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\r\n\u0002\b\u0002\b&\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u00042\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H'J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0017\u001a\u00020\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u0012\u0010\u001a\u001a\u00020\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\b\u0010\u001b\u001a\u00020\u0016H\u0016J\b\u0010\u001c\u001a\u00020\u0007H\u0014J\u0012\u0010\u001d\u001a\u00020\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J&\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\b\u0010$\u001a\u00020\u0016H\u0016J\u001a\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u001f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u0010\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u0007H\u0016J\u0010\u0010)\u001a\u00020\u00162\u0006\u0010*\u001a\u00020+H\u0016J\u0012\u0010)\u001a\u00020\u00162\b\b\u0001\u0010,\u001a\u00020\u0012H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u00028\u0000X\u0084.\u00a2\u0006\u0010\n\u0002\u0010\u0010\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006-"}, d2={"Lcom/ayvytr/flow/BaseFragment;", "T", "Lcom/ayvytr/flow/vm/BaseViewModel;", "Lcom/ayvytr/flow/base/IView;", "Landroidx/fragment/app/Fragment;", "()V", "isLazyLoaded", "", "()Z", "setLazyLoaded", "(Z)V", "viewModel", "getViewModel", "()Lcom/ayvytr/flow/vm/BaseViewModel;", "setViewModel", "(Lcom/ayvytr/flow/vm/BaseViewModel;)V", "Lcom/ayvytr/flow/vm/BaseViewModel;", "getContentViewRes", "", "getViewModelClass", "Ljava/lang/Class;", "hideLoading", "", "initData", "savedInstanceState", "Landroid/os/Bundle;", "initView", "initViewModel", "isLazyLoadEnabled", "onCreate", "onCreateView", "Landroid/view/View;", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "onResume", "onViewCreated", "view", "showLoading", "isShow", "showMessage", "message", "", "strId", "flow_release"})
public abstract class BaseFragment<T extends BaseViewModel<? extends IView>>
extends Fragment
implements IView {
    protected T viewModel;
    private boolean isLazyLoaded;

    @NotNull
    protected final T getViewModel() {
        T t = this.viewModel;
        if (t != null) {
            return t;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        return null;
    }

    protected final void setViewModel(@NotNull T t) {
        Intrinsics.checkNotNullParameter(t, (String)"<set-?>");
        this.viewModel = t;
    }

    protected final boolean isLazyLoaded() {
        return this.isLazyLoaded;
    }

    protected final void setLazyLoaded(boolean bl) {
        this.isLazyLoaded = bl;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.initViewModel();
    }

    @Nullable
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view;
        Intrinsics.checkNotNullParameter((Object)inflater, (String)"inflater");
        try {
            view = inflater.inflate(this.getContentViewRes(), container, false);
        }
        catch (Resources.NotFoundException e) {
            e.printStackTrace();
            return super.onCreateView(inflater, container, savedInstanceState);
        }
        return view;
    }

    @LayoutRes
    public abstract int getContentViewRes();

    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super.onViewCreated(view, savedInstanceState);
        this.initView(savedInstanceState);
        if (!this.isLazyLoadEnabled()) {
            this.initData(savedInstanceState);
        }
    }

    public void onResume() {
        super.onResume();
        if (this.isLazyLoadEnabled() && !this.isLazyLoaded && !this.isHidden()) {
            this.initData(null);
            this.isLazyLoaded = true;
        }
    }

    private final Class<T> getViewModelClass() {
        Type it$iv;
        block3: {
            boolean $i$f$getVmClass = false;
            Type type = this.getClass().getGenericSuperclass();
            if (type == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.reflect.ParameterizedType");
            }
            Type[] types$iv = ((ParameterizedType)type).getActualTypeArguments();
            Intrinsics.checkNotNullExpressionValue((Object)types$iv, (String)"types");
            Type[] $this$forEach$iv$iv = types$iv;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv$iv.length;
            for (int i = 0; i < n; ++i) {
                Type element$iv$iv;
                it$iv = element$iv$iv = $this$forEach$iv$iv[i];
                boolean bl = false;
                if (!(it$iv instanceof Class)) {
                    continue;
                }
                break block3;
            }
            throw new TypeCastException("Cannot find generic type VM");
        }
        return (Class)it$iv;
    }

    public void initViewModel() {
        BaseViewModel baseViewModel;
        BaseFragment baseFragment;
        BaseFragment baseFragment2 = this;
        try {
            baseFragment = baseFragment2;
            ViewModel viewModel = new ViewModelProvider((ViewModelStoreOwner)this).get(this.getViewModelClass());
            Intrinsics.checkNotNullExpressionValue((Object)viewModel, (String)"{\n            ViewModelP\u2026ewModelClass()]\n        }");
            baseViewModel = (BaseViewModel)viewModel;
        }
        catch (Exception e) {
            baseFragment = baseFragment2;
            baseViewModel = (BaseViewModel)new ViewModelProvider((ViewModelStoreOwner)this).get(BaseViewModel.class);
        }
        baseFragment.setViewModel(baseViewModel);
        ((BaseViewModel)((Object)this.getViewModel())).setIView((IView)this);
    }

    @Override
    public void initView(@Nullable Bundle savedInstanceState) {
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
    }

    @Override
    public void showLoading(boolean isShow) {
        Context context = this.requireContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
        BaseConfig.onShowLoading.invoke((Object)context, (Object)isShow);
    }

    @Override
    public void hideLoading() {
        this.showLoading(false);
    }

    @Override
    public void showMessage(@StringRes int strId) {
        String string = this.getString(strId);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(strId)");
        this.showMessage(string);
    }

    @Override
    public void showMessage(@NotNull CharSequence message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Context context = this.requireContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
        View view = this.requireView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"requireView()");
        BaseConfig.onShowMessage.invoke((Object)context, (Object)message, (Object)view);
    }

    protected boolean isLazyLoadEnabled() {
        return false;
    }
}

