/*
 * Decompiled with CFR 0.152.
 */
package io.github.azagniotov.metrics.reporter.cloudwatch;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Counting;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.codahale.metrics.jvm.BufferPoolMetricSet;
import com.codahale.metrics.jvm.ClassLoadingGaugeSet;
import com.codahale.metrics.jvm.FileDescriptorRatioGauge;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import io.github.azagniotov.metrics.reporter.cloudwatch.DimensionedName;
import io.github.azagniotov.metrics.reporter.utils.CollectionsUtils;
import java.lang.management.ManagementFactory;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.MetricDatum;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricDataRequest;
import software.amazon.awssdk.services.cloudwatch.model.StandardUnit;
import software.amazon.awssdk.services.cloudwatch.model.StatisticSet;

public class CloudWatchReporter
extends ScheduledReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloudWatchReporter.class);
    static final String DIMENSION_NAME_TYPE = "Type";
    static final String DIMENSION_GAUGE = "gauge";
    static final String DIMENSION_COUNT = "count";
    static final String DIMENSION_SNAPSHOT_SUMMARY = "snapshot-summary";
    static final String DIMENSION_SNAPSHOT_MEAN = "snapshot-mean";
    static final String DIMENSION_SNAPSHOT_STD_DEV = "snapshot-std-dev";
    private static final int HIGH_RESOLUTION = 1;
    private static final int STANDARD_RESOLUTION = 60;
    private static final double SMALLEST_SENDABLE_VALUE = 8.51592E-109;
    private static final double LARGEST_SENDABLE_VALUE = 1.174271E108;
    private static final int MAXIMUM_DATUMS_PER_REQUEST = 20;
    private final Map<Counting, Long> lastPolledCounts;
    private final Builder builder;
    private final String namespace;
    private final CloudWatchAsyncClient cloudWatchAsyncClient;
    private final StandardUnit rateUnit;
    private final StandardUnit durationUnit;
    private final boolean highResolution;

    private CloudWatchReporter(Builder builder) {
        super(builder.metricRegistry, "coda-hale-metrics-cloud-watch-reporter", builder.metricFilter, builder.rateUnit, builder.durationUnit);
        this.builder = builder;
        this.namespace = builder.namespace;
        this.cloudWatchAsyncClient = builder.cloudWatchAsyncClient;
        this.lastPolledCounts = new ConcurrentHashMap<Counting, Long>();
        this.rateUnit = builder.cwRateUnit;
        this.durationUnit = builder.cwDurationUnit;
        this.highResolution = builder.highResolution;
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        if (this.builder.withDryRun) {
            LOGGER.warn("** Reporter is running in 'DRY RUN' mode **");
        }
        try {
            ArrayList<MetricDatum> metricData = new ArrayList<MetricDatum>(gauges.size() + counters.size() + 10 * histograms.size() + 10 * timers.size());
            for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
                this.processGauge(entry.getKey(), entry.getValue(), metricData);
            }
            for (Map.Entry<String, Gauge> entry : counters.entrySet()) {
                this.processCounter(entry.getKey(), (Counting)entry.getValue(), metricData);
            }
            for (Map.Entry<String, Gauge> entry : histograms.entrySet()) {
                this.processCounter(entry.getKey(), (Counting)entry.getValue(), metricData);
                this.processHistogram(entry.getKey(), (Histogram)entry.getValue(), metricData);
            }
            for (Map.Entry<String, Gauge> entry : meters.entrySet()) {
                this.processCounter(entry.getKey(), (Counting)entry.getValue(), metricData);
                this.processMeter(entry.getKey(), (Metered)entry.getValue(), metricData);
            }
            for (Map.Entry<String, Gauge> entry : timers.entrySet()) {
                this.processCounter(entry.getKey(), (Counting)entry.getValue(), metricData);
                this.processMeter(entry.getKey(), (Metered)entry.getValue(), metricData);
                this.processTimer(entry.getKey(), (Timer)entry.getValue(), metricData);
            }
            Collection<List<MetricDatum>> metricDataPartitions = CollectionsUtils.partition(metricData, 20);
            ArrayList<CompletableFuture> arrayList = new ArrayList<CompletableFuture>(metricData.size());
            for (List<MetricDatum> list : metricDataPartitions) {
                PutMetricDataRequest putMetricDataRequest = (PutMetricDataRequest)PutMetricDataRequest.builder().namespace(this.namespace).metricData(list).build();
                if (this.builder.withDryRun) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("Dry run - constructed PutMetricDataRequest: {}", (Object)putMetricDataRequest);
                    continue;
                }
                arrayList.add(this.cloudWatchAsyncClient.putMetricData(putMetricDataRequest));
            }
            for (Future future : arrayList) {
                try {
                    future.get();
                }
                catch (Exception e) {
                    LOGGER.error("Error reporting metrics to CloudWatch. The data in this CloudWatch API request may have been discarded, did not make it to CloudWatch.", (Throwable)e);
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Sent {} metric datums to CloudWatch. Namespace: {}, metric data {}", new Object[]{metricData.size(), this.namespace, metricData});
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("Error marshalling CloudWatch metrics.", (Throwable)e);
        }
    }

    public void stop() {
        try {
            super.stop();
        }
        catch (Exception e) {
            LOGGER.error("Error when stopping the reporter.", (Throwable)e);
        }
        finally {
            if (!this.builder.withDryRun) {
                try {
                    this.cloudWatchAsyncClient.close();
                }
                catch (Exception e) {
                    LOGGER.error("Error shutting down AmazonCloudWatchAsync", (Object)this.cloudWatchAsyncClient, (Object)e);
                }
            }
        }
    }

    private void processGauge(String metricName, Gauge gauge, List<MetricDatum> metricData) {
        Optional.ofNullable(gauge.getValue()).filter(value -> value instanceof Number).map(value -> (Number)value).ifPresent(value -> this.stageMetricDatum(true, metricName, value.doubleValue(), StandardUnit.NONE, DIMENSION_GAUGE, metricData));
    }

    private void processCounter(String metricName, Counting counter, List<MetricDatum> metricData) {
        long currentCount = counter.getCount();
        Long lastCount = this.lastPolledCounts.get(counter);
        this.lastPolledCounts.put(counter, currentCount);
        if (lastCount == null) {
            lastCount = 0L;
        }
        long reportValue = this.builder.withReportRawCountValue ? currentCount : currentCount - lastCount;
        this.stageMetricDatum(true, metricName, reportValue, StandardUnit.COUNT, DIMENSION_COUNT, metricData);
    }

    private void processMeter(String metricName, Metered meter, List<MetricDatum> metricData) {
        String formattedRate = String.format("-rate [per-%s]", this.getRateUnit());
        this.stageMetricDatum(this.builder.withOneMinuteMeanRate, metricName, this.convertRate(meter.getOneMinuteRate()), this.rateUnit, "1-min-mean" + formattedRate, metricData);
        this.stageMetricDatum(this.builder.withFiveMinuteMeanRate, metricName, this.convertRate(meter.getFiveMinuteRate()), this.rateUnit, "5-min-mean" + formattedRate, metricData);
        this.stageMetricDatum(this.builder.withFifteenMinuteMeanRate, metricName, this.convertRate(meter.getFifteenMinuteRate()), this.rateUnit, "15-min-mean" + formattedRate, metricData);
        this.stageMetricDatum(this.builder.withMeanRate, metricName, this.convertRate(meter.getMeanRate()), this.rateUnit, "mean" + formattedRate, metricData);
    }

    private void processTimer(String metricName, Timer timer, List<MetricDatum> metricData) {
        Snapshot snapshot = timer.getSnapshot();
        if (this.builder.withZeroValuesSubmission || snapshot.size() > 0) {
            for (Percentile percentile : this.builder.percentiles) {
                double convertedDuration = this.convertDuration(snapshot.getValue(percentile.getQuantile()));
                this.stageMetricDatum(true, metricName, convertedDuration, this.durationUnit, percentile.getDesc(), metricData);
            }
        }
        if (snapshot.size() > 0) {
            String formattedDuration = String.format(" [in-%s]", this.getDurationUnit());
            this.stageMetricDatum(this.builder.withArithmeticMean, metricName, this.convertDuration(snapshot.getMean()), this.durationUnit, DIMENSION_SNAPSHOT_MEAN + formattedDuration, metricData);
            this.stageMetricDatum(this.builder.withStdDev, metricName, this.convertDuration(snapshot.getStdDev()), this.durationUnit, DIMENSION_SNAPSHOT_STD_DEV + formattedDuration, metricData);
            this.stageMetricDatumWithConvertedSnapshot(this.builder.withStatisticSet, metricName, snapshot, this.durationUnit, metricData);
        }
    }

    private void processHistogram(String metricName, Histogram histogram, List<MetricDatum> metricData) {
        Snapshot snapshot = histogram.getSnapshot();
        if (this.builder.withZeroValuesSubmission || snapshot.size() > 0) {
            for (Percentile percentile : this.builder.percentiles) {
                double value = snapshot.getValue(percentile.getQuantile());
                this.stageMetricDatum(true, metricName, value, StandardUnit.NONE, percentile.getDesc(), metricData);
            }
        }
        if (snapshot.size() > 0) {
            this.stageMetricDatum(this.builder.withArithmeticMean, metricName, snapshot.getMean(), StandardUnit.NONE, DIMENSION_SNAPSHOT_MEAN, metricData);
            this.stageMetricDatum(this.builder.withStdDev, metricName, snapshot.getStdDev(), StandardUnit.NONE, DIMENSION_SNAPSHOT_STD_DEV, metricData);
            this.stageMetricDatumWithRawSnapshot(this.builder.withStatisticSet, metricName, snapshot, StandardUnit.NONE, metricData);
        }
    }

    private void stageMetricDatum(boolean metricConfigured, String metricName, double metricValue, StandardUnit standardUnit, String dimensionValue, List<MetricDatum> metricData) {
        if (metricConfigured && (this.builder.withZeroValuesSubmission || metricValue > 0.0)) {
            DimensionedName dimensionedName = DimensionedName.decode(metricName);
            LinkedHashSet<Object> dimensions = new LinkedHashSet<Object>(this.builder.globalDimensions);
            dimensions.add(Dimension.builder().name(DIMENSION_NAME_TYPE).value(dimensionValue).build());
            dimensions.addAll(dimensionedName.getDimensions());
            metricData.add((MetricDatum)MetricDatum.builder().timestamp(Instant.ofEpochMilli(this.builder.clock.getTime())).value(Double.valueOf(this.cleanMetricValue(metricValue))).metricName(dimensionedName.getName()).dimensions(dimensions).storageResolution(Integer.valueOf(this.highResolution ? 1 : 60)).unit(standardUnit).build());
        }
    }

    private void stageMetricDatumWithConvertedSnapshot(boolean metricConfigured, String metricName, Snapshot snapshot, StandardUnit standardUnit, List<MetricDatum> metricData) {
        if (metricConfigured) {
            DimensionedName dimensionedName = DimensionedName.decode(metricName);
            double scaledSum = this.convertDuration(LongStream.of(snapshot.getValues()).sum());
            StatisticSet statisticSet = (StatisticSet)StatisticSet.builder().sum(Double.valueOf(scaledSum)).sampleCount(Double.valueOf(snapshot.size())).minimum(Double.valueOf(this.convertDuration(snapshot.getMin()))).maximum(Double.valueOf(this.convertDuration(snapshot.getMax()))).build();
            LinkedHashSet<Object> dimensions = new LinkedHashSet<Object>(this.builder.globalDimensions);
            dimensions.add(Dimension.builder().name(DIMENSION_NAME_TYPE).value(DIMENSION_SNAPSHOT_SUMMARY).build());
            dimensions.addAll(dimensionedName.getDimensions());
            metricData.add((MetricDatum)MetricDatum.builder().timestamp(Instant.ofEpochMilli(this.builder.clock.getTime())).metricName(dimensionedName.getName()).dimensions(dimensions).statisticValues(statisticSet).storageResolution(Integer.valueOf(this.highResolution ? 1 : 60)).unit(standardUnit).build());
        }
    }

    private void stageMetricDatumWithRawSnapshot(boolean metricConfigured, String metricName, Snapshot snapshot, StandardUnit standardUnit, List<MetricDatum> metricData) {
        if (metricConfigured) {
            DimensionedName dimensionedName = DimensionedName.decode(metricName);
            double total = LongStream.of(snapshot.getValues()).sum();
            StatisticSet statisticSet = (StatisticSet)StatisticSet.builder().sum(Double.valueOf(total)).sampleCount(Double.valueOf(snapshot.size())).minimum(Double.valueOf(snapshot.getMin())).maximum(Double.valueOf(snapshot.getMax())).build();
            LinkedHashSet<Object> dimensions = new LinkedHashSet<Object>(this.builder.globalDimensions);
            dimensions.add(Dimension.builder().name(DIMENSION_NAME_TYPE).value(DIMENSION_SNAPSHOT_SUMMARY).build());
            dimensions.addAll(dimensionedName.getDimensions());
            metricData.add((MetricDatum)MetricDatum.builder().timestamp(Instant.ofEpochMilli(this.builder.clock.getTime())).metricName(dimensionedName.getName()).dimensions(dimensions).statisticValues(statisticSet).storageResolution(Integer.valueOf(this.highResolution ? 1 : 60)).unit(standardUnit).build());
        }
    }

    private double cleanMetricValue(double metricValue) {
        double absoluteValue = Math.abs(metricValue);
        if (absoluteValue < 8.51592E-109) {
            if (absoluteValue > 0.0) {
                if (metricValue < 0.0) {
                    return -8.51592E-109;
                }
                return 8.51592E-109;
            }
        } else if (absoluteValue > 1.174271E108) {
            if (metricValue < 0.0) {
                return -1.174271E108;
            }
            return 1.174271E108;
        }
        return metricValue;
    }

    public static Builder forRegistry(MetricRegistry metricRegistry, CloudWatchAsyncClient client, String namespace) {
        return new Builder(metricRegistry, client, namespace);
    }

    public static class Builder {
        private final String namespace;
        private final CloudWatchAsyncClient cloudWatchAsyncClient;
        private final MetricRegistry metricRegistry;
        private Percentile[] percentiles;
        private boolean withOneMinuteMeanRate;
        private boolean withFiveMinuteMeanRate;
        private boolean withFifteenMinuteMeanRate;
        private boolean withMeanRate;
        private boolean withArithmeticMean;
        private boolean withStdDev;
        private boolean withDryRun;
        private boolean withZeroValuesSubmission;
        private boolean withStatisticSet;
        private boolean withJvmMetrics;
        private boolean withReportRawCountValue;
        private MetricFilter metricFilter;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private Optional<StandardUnit> cwMeterUnit;
        private StandardUnit cwRateUnit;
        private StandardUnit cwDurationUnit;
        private Set<Dimension> globalDimensions;
        private final Clock clock;
        private boolean highResolution;

        private Builder(MetricRegistry metricRegistry, CloudWatchAsyncClient cloudWatchAsyncClient, String namespace) {
            this.metricRegistry = metricRegistry;
            this.cloudWatchAsyncClient = cloudWatchAsyncClient;
            this.namespace = namespace;
            this.percentiles = new Percentile[]{Percentile.P75, Percentile.P95, Percentile.P999};
            this.metricFilter = MetricFilter.ALL;
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.globalDimensions = new LinkedHashSet<Dimension>();
            this.cwMeterUnit = Optional.empty();
            this.cwRateUnit = this.toStandardUnit(this.rateUnit);
            this.cwDurationUnit = this.toStandardUnit(this.durationUnit);
            this.clock = Clock.defaultClock();
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder filter(MetricFilter metricFilter) {
            this.metricFilter = metricFilter;
            return this;
        }

        public Builder withOneMinuteMeanRate() {
            this.withOneMinuteMeanRate = true;
            return this;
        }

        public Builder withFiveMinuteMeanRate() {
            this.withFiveMinuteMeanRate = true;
            return this;
        }

        public Builder withFifteenMinuteMeanRate() {
            this.withFifteenMinuteMeanRate = true;
            return this;
        }

        public Builder withMeanRate() {
            this.withMeanRate = true;
            return this;
        }

        public Builder withArithmeticMean() {
            this.withArithmeticMean = true;
            return this;
        }

        public Builder withStdDev() {
            this.withStdDev = true;
            return this;
        }

        public Builder withStatisticSet() {
            this.withStatisticSet = true;
            return this;
        }

        public Builder withJvmMetrics() {
            this.withJvmMetrics = true;
            return this;
        }

        public Builder withDryRun() {
            this.withDryRun = true;
            return this;
        }

        public Builder withZeroValuesSubmission() {
            this.withZeroValuesSubmission = true;
            return this;
        }

        public Builder withReportRawCountValue() {
            this.withReportRawCountValue = true;
            return this;
        }

        public Builder withPercentiles(Percentile ... percentiles) {
            this.percentiles = percentiles;
            return this;
        }

        public Builder withGlobalDimensions(String ... dimensions) {
            for (String pair : dimensions) {
                List splitted = Stream.of(pair.split("=")).map(String::trim).collect(Collectors.toList());
                this.globalDimensions.add((Dimension)Dimension.builder().name((String)splitted.get(0)).value((String)splitted.get(1)).build());
            }
            return this;
        }

        public Builder withHighResolution() {
            this.highResolution = true;
            return this;
        }

        public Builder withMeterUnitSentToCW(StandardUnit reportUnit) {
            this.cwMeterUnit = Optional.of(reportUnit);
            return this;
        }

        public CloudWatchReporter build() {
            if (this.withJvmMetrics) {
                this.metricRegistry.register("jvm.uptime", (Metric)((Gauge)() -> ManagementFactory.getRuntimeMXBean().getUptime()));
                this.metricRegistry.register("jvm.current_time", (Metric)((Gauge)() -> ((Clock)this.clock).getTime()));
                this.metricRegistry.register("jvm.classes", (Metric)new ClassLoadingGaugeSet());
                this.metricRegistry.register("jvm.fd_usage", (Metric)new FileDescriptorRatioGauge());
                this.metricRegistry.register("jvm.buffers", (Metric)new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer()));
                this.metricRegistry.register("jvm.gc", (Metric)new GarbageCollectorMetricSet());
                this.metricRegistry.register("jvm.memory", (Metric)new MemoryUsageGaugeSet());
                this.metricRegistry.register("jvm.thread-states", (Metric)new ThreadStatesGaugeSet());
            }
            this.cwRateUnit = this.cwMeterUnit.orElse(this.toStandardUnit(this.rateUnit));
            this.cwDurationUnit = this.toStandardUnit(this.durationUnit);
            return new CloudWatchReporter(this);
        }

        private StandardUnit toStandardUnit(TimeUnit timeUnit) {
            switch (timeUnit) {
                case SECONDS: {
                    return StandardUnit.SECONDS;
                }
                case MILLISECONDS: {
                    return StandardUnit.MILLISECONDS;
                }
                case MICROSECONDS: {
                    return StandardUnit.MICROSECONDS;
                }
            }
            throw new IllegalArgumentException("Unsupported TimeUnit: " + (Object)((Object)timeUnit));
        }
    }

    public static enum Percentile {
        P50(0.5, "50%"),
        P75(0.75, "75%"),
        P95(0.95, "95%"),
        P98(0.98, "98%"),
        P99(0.99, "99%"),
        P995(0.995, "99.5%"),
        P999(0.999, "99.9%");

        private final double quantile;
        private final String desc;

        private Percentile(double quantile, String desc) {
            this.quantile = quantile;
            this.desc = desc;
        }

        public double getQuantile() {
            return this.quantile;
        }

        public String getDesc() {
            return this.desc;
        }
    }
}

