/*
 * Decompiled with CFR 0.152.
 */
package io.github.azagniotov.metrics.reporter.cloudwatch;

import io.github.azagniotov.metrics.reporter.cloudwatch.DimensionedNameBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;

public class DimensionedName {
    private static final Pattern dimensionPattern = Pattern.compile("([\\w.-]+)\\[([\\w\\W]+)]");
    private final String name;
    private final Map<String, Dimension> dimensions;
    private String encoded;

    DimensionedName(String name, Map<String, Dimension> dimensions) {
        this.name = name;
        this.dimensions = Collections.unmodifiableMap(dimensions);
    }

    public static DimensionedName decode(String encodedDimensionedName) {
        Matcher matcher = dimensionPattern.matcher(encodedDimensionedName);
        if (matcher.find() && matcher.groupCount() == 2) {
            DimensionedNameBuilder builder = new DimensionedNameBuilder(matcher.group(1).trim());
            for (String t : matcher.group(2).split(",")) {
                String[] keyAndValue = t.split(":");
                builder.withDimension(keyAndValue[0].trim(), keyAndValue[1].trim());
            }
            return builder.build();
        }
        return new DimensionedNameBuilder(encodedDimensionedName).build();
    }

    public static DimensionedNameBuilder withName(String name) {
        return new DimensionedNameBuilder(name);
    }

    public DimensionedNameBuilder withDimension(String name, String value) {
        return new DimensionedNameBuilder(this.name, new HashMap<String, Dimension>(this.dimensions)).withDimension(name, value);
    }

    public String getName() {
        return this.name;
    }

    public Set<Dimension> getDimensions() {
        return new HashSet<Dimension>(this.dimensions.values());
    }

    public synchronized String encode() {
        if (this.encoded == null) {
            if (!this.dimensions.isEmpty()) {
                StringBuilder sb = new StringBuilder(this.name);
                sb.append('[');
                sb.append(this.dimensions.values().stream().map(dimension -> dimension.name() + ":" + dimension.value()).collect(Collectors.joining(",")));
                sb.append(']');
                this.encoded = sb.toString();
            } else {
                this.encoded = this.name;
            }
        }
        return this.encoded;
    }

    public String toString() {
        return this.encode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimensionedName that = (DimensionedName)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.dimensions, that.dimensions);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.dimensions);
    }
}

