/*
 * Decompiled with CFR 0.152.
 */
package io.github.bakedlibs.dough.protection;

import io.github.bakedlibs.dough.common.DoughLogger;
import io.github.bakedlibs.dough.protection.Interaction;
import io.github.bakedlibs.dough.protection.ProtectionLogger;
import io.github.bakedlibs.dough.protection.ProtectionModule;
import io.github.bakedlibs.dough.protection.loggers.CoreProtectLogger;
import io.github.bakedlibs.dough.protection.loggers.LogBlockLogger;
import io.github.bakedlibs.dough.protection.modules.BentoBoxProtectionModule;
import io.github.bakedlibs.dough.protection.modules.BlockLockerProtectionModule;
import io.github.bakedlibs.dough.protection.modules.ChestProtectProtectionModule;
import io.github.bakedlibs.dough.protection.modules.FactionsUUIDProtectionModule;
import io.github.bakedlibs.dough.protection.modules.FunnyGuildsProtectionModule;
import io.github.bakedlibs.dough.protection.modules.GriefPreventionProtectionModule;
import io.github.bakedlibs.dough.protection.modules.LWCProtectionModule;
import io.github.bakedlibs.dough.protection.modules.LandsProtectionModule;
import io.github.bakedlibs.dough.protection.modules.LocketteProtectionModule;
import io.github.bakedlibs.dough.protection.modules.PlotSquaredProtectionModule;
import io.github.bakedlibs.dough.protection.modules.PreciousStonesProtectionModule;
import io.github.bakedlibs.dough.protection.modules.RedProtectProtectionModule;
import io.github.bakedlibs.dough.protection.modules.TownyProtectionModule;
import io.github.bakedlibs.dough.protection.modules.WorldGuardProtectionModule;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;

public final class ProtectionManager {
    private final Set<ProtectionModule> protectionModules = new HashSet<ProtectionModule>();
    private final Set<ProtectionLogger> protectionLoggers = new HashSet<ProtectionLogger>();
    private final Logger logger;

    public ProtectionManager(@Nonnull Server server) {
        this.logger = new DoughLogger(server, "protection");
        this.logger.log(Level.INFO, "Loading Protection Modules...");
        this.logger.log(Level.INFO, "This may happen more than once.");
        this.registerModule(server, "WorldGuard", plugin -> new WorldGuardProtectionModule((Plugin)plugin));
        this.registerModule(server, "Towny", plugin -> new TownyProtectionModule((Plugin)plugin));
        this.registerModule(server, "GriefPrevention", plugin -> new GriefPreventionProtectionModule((Plugin)plugin));
        this.registerModule(server, "LWC", plugin -> new LWCProtectionModule((Plugin)plugin));
        this.registerModule(server, "PreciousStones", plugin -> new PreciousStonesProtectionModule((Plugin)plugin));
        this.registerModule(server, "Lockette", plugin -> new LocketteProtectionModule((Plugin)plugin));
        this.registerModule(server, "RedProtect", plugin -> new RedProtectProtectionModule((Plugin)plugin));
        this.registerModule(server, "BentoBox", plugin -> new BentoBoxProtectionModule((Plugin)plugin));
        this.registerModule(server, "BlockLocker", plugin -> new BlockLockerProtectionModule((Plugin)plugin));
        this.registerModule(server, "Lands", plugin -> new LandsProtectionModule((Plugin)plugin));
        this.registerModule(server, "ChestProtect", plugin -> new ChestProtectProtectionModule((Plugin)plugin));
        this.registerModule(server, "Factions", plugin -> new FactionsUUIDProtectionModule((Plugin)plugin));
        this.registerModule(server, "FunnyGuilds", plugin -> new FunnyGuildsProtectionModule((Plugin)plugin));
        this.registerModule(server, "PlotSquared", plugin -> new PlotSquaredProtectionModule((Plugin)plugin));
        if (server.getPluginManager().isPluginEnabled("CoreProtect")) {
            this.registerLogger(new CoreProtectLogger());
        }
        if (server.getPluginManager().isPluginEnabled("LogBlock")) {
            this.registerLogger(new LogBlockLogger());
        }
        if (server.getPluginManager().isPluginEnabled("ProtectionStones")) {
            this.loadModuleMSG("ProtectionStones");
        }
        if (server.getPluginManager().isPluginEnabled("uSkyblock")) {
            this.loadModuleMSG("uSkyblock");
        }
    }

    public void registerLogger(@Nonnull String name, @Nonnull ProtectionLogger module) {
        this.protectionLoggers.add(module);
        this.loadModuleMSG(name);
    }

    public void registerModule(@Nonnull Server server, @Nonnull String pluginName, @Nonnull Function<Plugin, ProtectionModule> constructor) {
        Plugin plugin = server.getPluginManager().getPlugin(pluginName);
        if (plugin != null && plugin.isEnabled()) {
            this.registerModule(plugin, constructor);
        }
    }

    private void registerModule(@Nonnull Plugin plugin, @Nonnull Function<Plugin, ProtectionModule> constructor) {
        try {
            ProtectionModule module = constructor.apply(plugin);
            module.load();
            this.protectionModules.add(module);
            this.loadModuleMSG(module.getName() + " v" + module.getVersion());
        }
        catch (Throwable x) {
            this.logger.log(Level.SEVERE, x, () -> "An Error occured while registering the Protection Module: \"" + plugin.getName() + "\" v" + plugin.getDescription().getVersion());
        }
    }

    public void registerLogger(@Nonnull ProtectionLogger module) {
        try {
            module.load();
            this.registerLogger(module.getName(), module);
        }
        catch (Throwable x) {
            this.logger.log(Level.SEVERE, x, () -> "An Error occured while registering the Protection Module: \"" + module.getName() + "\"");
        }
    }

    private void loadModuleMSG(String module) {
        this.logger.log(Level.INFO, "Loaded Protection Module \"{0}\"", module);
    }

    public boolean hasPermission(@Nonnull OfflinePlayer p, @Nonnull Block b, @Nonnull Interaction action) {
        return this.hasPermission(p, b.getLocation(), action);
    }

    public boolean hasPermission(@Nonnull OfflinePlayer p, @Nonnull Location l, @Nonnull Interaction action) {
        for (ProtectionModule module : this.protectionModules) {
            try {
                if (module.hasPermission(p, l, action)) continue;
                return false;
            }
            catch (Exception | LinkageError x) {
                this.logger.log(Level.SEVERE, x, () -> "An Error occured while querying the Protection Module: \"" + module.getName() + " v" + module.getVersion() + "\"");
                return true;
            }
        }
        return true;
    }

    public void logAction(@Nonnull OfflinePlayer p, @Nonnull Block b, @Nonnull Interaction action) {
        for (ProtectionLogger module : this.protectionLoggers) {
            try {
                module.logAction(p, b, action);
            }
            catch (Exception | LinkageError x) {
                this.logger.log(Level.SEVERE, x, () -> "An Error occured while logging for the Protection Module: \"" + module.getName() + "\"");
            }
        }
    }
}

