/*
 * Decompiled with CFR 0.152.
 */
package io.github.bakedlibs.dough.protection.modules;

import io.github.bakedlibs.dough.protection.Interaction;
import io.github.bakedlibs.dough.protection.ProtectionModule;
import javax.annotation.Nonnull;
import me.angeschossen.lands.api.flags.Flags;
import me.angeschossen.lands.api.flags.types.RoleFlag;
import me.angeschossen.lands.api.integration.LandsIntegration;
import me.angeschossen.lands.api.land.Area;
import me.angeschossen.lands.api.land.LandWorld;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;

public class LandsProtectionModule
implements ProtectionModule {
    private LandsIntegration landsIntegration;
    private final Plugin plugin;

    public LandsProtectionModule(@Nonnull Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public void load() {
        this.landsIntegration = new LandsIntegration(this.plugin);
    }

    @Override
    public boolean hasPermission(OfflinePlayer p, Location l, Interaction action) {
        LandWorld landWorld = this.landsIntegration.getLandWorld(l.getWorld());
        if (landWorld == null) {
            return true;
        }
        Area area = landWorld.getArea(l);
        return area == null || area.hasFlag(p.getUniqueId(), this.convert(action));
    }

    @Nonnull
    private RoleFlag convert(@Nonnull Interaction protectableAction) {
        switch (protectableAction) {
            case PLACE_BLOCK: {
                return Flags.BLOCK_PLACE;
            }
            case BREAK_BLOCK: {
                return Flags.BLOCK_BREAK;
            }
            case ATTACK_PLAYER: {
                return Flags.ATTACK_PLAYER;
            }
            case INTERACT_BLOCK: {
                return Flags.INTERACT_CONTAINER;
            }
            case INTERACT_ENTITY: {
                return Flags.INTERACT_VILLAGER;
            }
            case ATTACK_ENTITY: {
                return Flags.ATTACK_ANIMAL;
            }
        }
        return Flags.BLOCK_BREAK;
    }
}

