/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.eclipse.paho.client.mqttv3.MqttToken;
import org.eclipse.paho.client.mqttv3.MqttTopic;
import org.eclipse.paho.client.mqttv3.internal.ClientState;
import org.eclipse.paho.client.mqttv3.internal.CommsCallback;
import org.eclipse.paho.client.mqttv3.internal.CommsReceiver;
import org.eclipse.paho.client.mqttv3.internal.CommsSender;
import org.eclipse.paho.client.mqttv3.internal.CommsTokenStore;
import org.eclipse.paho.client.mqttv3.internal.ExceptionHelper;
import org.eclipse.paho.client.mqttv3.internal.NetworkModule;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttConnack;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttConnect;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttDisconnect;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPublish;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;

public class ClientComms {
    public static String VERSION = "0.4.0";
    public static String BUILD_LEVEL = "L20141127-0458";
    private IMqttAsyncClient client;
    private int networkModuleIndex;
    private NetworkModule[] networkModules;
    CommsReceiver receiver;
    CommsSender sender;
    CommsCallback callback;
    ClientState clientState;
    MqttConnectOptions conOptions;
    private MqttClientPersistence persistence;
    CommsTokenStore tokenStore;
    boolean stoppingComms = false;
    static final byte CONNECTED = 0;
    static final byte CONNECTING = 1;
    static final byte DISCONNECTING = 2;
    static final byte DISCONNECTED = 3;
    static final byte CLOSED = 4;
    private byte conState = (byte)3;
    Object conLock = new Object();
    private boolean closePending = false;
    static final String className = ClientComms.class.getName();
    Logger log = LoggerFactory.getLogger("org.eclipse.paho.client.mqttv3.internal.nls.logcat", className);

    public ClientComms(IMqttAsyncClient client, MqttClientPersistence persistence) throws MqttException {
        this.conState = (byte)3;
        this.client = client;
        this.persistence = persistence;
        this.tokenStore = new CommsTokenStore(this.getClient().getClientId());
        this.callback = new CommsCallback(this);
        this.clientState = new ClientState(persistence, this.tokenStore, this.callback, this);
        this.callback.setClientState(this.clientState);
        this.log.setResourceName(this.getClient().getClientId());
    }

    void internalSend(MqttWireMessage message, MqttToken token) throws MqttException {
        String methodName = "internalSend";
        this.log.fine(className, "internalSend", "200", new Object[]{message.getKey(), message, token});
        if (token.getClient() != null) {
            this.log.fine(className, "internalSend", "213", new Object[]{message.getKey(), message, token});
            throw new MqttException(32201);
        }
        token.internalTok.setClient(this.getClient());
        try {
            this.clientState.send(message, token);
        }
        catch (MqttException e) {
            if (message instanceof MqttPublish) {
                this.clientState.undo((MqttPublish)message);
            }
            throw e;
        }
    }

    public void sendNoWait(MqttWireMessage message, MqttToken token) throws MqttException {
        String methodName = "sendNoWait";
        if (!(this.isConnected() || !this.isConnected() && message instanceof MqttConnect || this.isDisconnecting() && message instanceof MqttDisconnect)) {
            this.log.fine(className, "sendNoWait", "208");
            throw ExceptionHelper.createMqttException(32104);
        }
        this.internalSend(message, token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws MqttException {
        String methodName = "close";
        Object object = this.conLock;
        synchronized (object) {
            if (!this.isClosed()) {
                if (!this.isDisconnected()) {
                    this.log.fine(className, "close", "224");
                    if (this.isConnecting()) {
                        throw new MqttException(32110);
                    }
                    if (this.isConnected()) {
                        throw ExceptionHelper.createMqttException(32100);
                    }
                    if (this.isDisconnecting()) {
                        this.closePending = true;
                        return;
                    }
                }
                this.conState = (byte)4;
                this.clientState.close();
                this.clientState = null;
                this.callback = null;
                this.persistence = null;
                this.sender = null;
                this.receiver = null;
                this.networkModules = null;
                this.conOptions = null;
                this.tokenStore = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(MqttConnectOptions options, MqttToken token) throws MqttException {
        String methodName = "connect";
        Object object = this.conLock;
        synchronized (object) {
            if (!this.isDisconnected() || this.closePending) {
                this.log.fine(className, "connect", "207", new Object[]{new Byte(this.conState)});
                if (this.isClosed() || this.closePending) {
                    throw new MqttException(32111);
                }
                if (this.isConnecting()) {
                    throw new MqttException(32110);
                }
                if (this.isDisconnecting()) {
                    throw new MqttException(32102);
                }
                throw ExceptionHelper.createMqttException(32100);
            }
            this.log.fine(className, "connect", "214");
            this.conState = 1;
            this.conOptions = options;
            MqttConnect connect = new MqttConnect(this.client.getClientId(), options.isCleanSession(), options.getKeepAliveInterval(), options.getUserName(), options.getPassword(), options.getWillMessage(), options.getWillDestination());
            this.clientState.setKeepAliveSecs(options.getKeepAliveInterval());
            this.clientState.setCleanSession(options.isCleanSession());
            this.tokenStore.open();
            ConnectBG conbg = new ConnectBG(this, token, connect);
            conbg.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectComplete(MqttConnack cack, MqttException mex) throws MqttException {
        String methodName = "connectComplete";
        int rc = cack.getReturnCode();
        Object object = this.conLock;
        synchronized (object) {
            if (rc == 0) {
                this.log.fine(className, "connectComplete", "215");
                this.conState = 0;
                return;
            }
        }
        this.log.fine(className, "connectComplete", "204", new Object[]{new Integer(rc)});
        throw mex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownConnection(MqttToken token, MqttException reason) {
        boolean wasConnected;
        String methodName = "shutdownConnection";
        MqttToken endToken = null;
        Object object = this.conLock;
        synchronized (object) {
            if (this.stoppingComms || this.closePending) {
                return;
            }
            this.stoppingComms = true;
            this.log.fine(className, "shutdownConnection", "216");
            wasConnected = this.isConnected() || this.isDisconnecting();
            this.conState = (byte)2;
        }
        if (token != null && !token.isComplete()) {
            token.internalTok.setException(reason);
        }
        if (this.callback != null) {
            this.callback.stop();
        }
        try {
            NetworkModule networkModule;
            if (this.networkModules != null && (networkModule = this.networkModules[this.networkModuleIndex]) != null) {
                networkModule.stop();
            }
        }
        catch (Exception ioe) {
            // empty catch block
        }
        if (this.receiver != null) {
            this.receiver.stop();
        }
        this.tokenStore.quiesce(new MqttException(32102));
        endToken = this.handleOldTokens(token, reason);
        try {
            this.clientState.disconnected(reason);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (this.sender != null) {
            this.sender.stop();
        }
        try {
            if (this.persistence != null) {
                this.persistence.close();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        object = this.conLock;
        synchronized (object) {
            this.log.fine(className, "shutdownConnection", "217");
            this.conState = (byte)3;
            this.stoppingComms = false;
        }
        if (endToken != null & this.callback != null) {
            this.callback.asyncOperationComplete(endToken);
        }
        if (wasConnected && this.callback != null) {
            this.callback.connectionLost(reason);
        }
        object = this.conLock;
        synchronized (object) {
            if (this.closePending) {
                try {
                    this.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    private MqttToken handleOldTokens(MqttToken token, MqttException reason) {
        String methodName = "handleOldTokens";
        this.log.fine(className, "handleOldTokens", "222");
        MqttToken tokToNotifyLater = null;
        try {
            if (token != null && this.tokenStore.getToken(token.internalTok.getKey()) == null) {
                this.tokenStore.saveToken(token, token.internalTok.getKey());
            }
            Vector toksToNot = this.clientState.resolveOldTokens(reason);
            Enumeration toksToNotE = toksToNot.elements();
            while (toksToNotE.hasMoreElements()) {
                MqttToken tok = (MqttToken)toksToNotE.nextElement();
                if (tok.internalTok.getKey().equals(MqttDisconnect.KEY) || tok.internalTok.getKey().equals(MqttConnect.KEY)) {
                    tokToNotifyLater = tok;
                    continue;
                }
                this.callback.asyncOperationComplete(tok);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return tokToNotifyLater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(MqttDisconnect disconnect, long quiesceTimeout, MqttToken token) throws MqttException {
        String methodName = "disconnect";
        Object object = this.conLock;
        synchronized (object) {
            if (this.isClosed()) {
                this.log.fine(className, "disconnect", "223");
                throw ExceptionHelper.createMqttException(32111);
            }
            if (this.isDisconnected()) {
                this.log.fine(className, "disconnect", "211");
                throw ExceptionHelper.createMqttException(32101);
            }
            if (this.isDisconnecting()) {
                this.log.fine(className, "disconnect", "219");
                throw ExceptionHelper.createMqttException(32102);
            }
            if (Thread.currentThread() == this.callback.getThread()) {
                this.log.fine(className, "disconnect", "210");
                throw ExceptionHelper.createMqttException(32107);
            }
            this.log.fine(className, "disconnect", "218");
            this.conState = (byte)2;
            DisconnectBG discbg = new DisconnectBG(disconnect, quiesceTimeout, token);
            discbg.start();
        }
    }

    public boolean isConnected() {
        return this.conState == 0;
    }

    public boolean isConnecting() {
        return this.conState == 1;
    }

    public boolean isDisconnected() {
        return this.conState == 3;
    }

    public boolean isDisconnecting() {
        return this.conState == 2;
    }

    public boolean isClosed() {
        return this.conState == 4;
    }

    public void setCallback(MqttCallback mqttCallback) {
        this.callback.setCallback(mqttCallback);
    }

    protected MqttTopic getTopic(String topic) {
        return new MqttTopic(topic, this);
    }

    public void setNetworkModuleIndex(int index) {
        this.networkModuleIndex = index;
    }

    public int getNetworkModuleIndex() {
        return this.networkModuleIndex;
    }

    public NetworkModule[] getNetworkModules() {
        return this.networkModules;
    }

    public void setNetworkModules(NetworkModule[] networkModules) {
        this.networkModules = networkModules;
    }

    public MqttDeliveryToken[] getPendingDeliveryTokens() {
        return this.tokenStore.getOutstandingDelTokens();
    }

    protected void deliveryComplete(MqttPublish msg) throws MqttPersistenceException {
        this.clientState.deliveryComplete(msg);
    }

    public IMqttAsyncClient getClient() {
        return this.client;
    }

    public long getKeepAlive() {
        return this.clientState.getKeepAlive();
    }

    public ClientState getClientState() {
        return this.clientState;
    }

    public MqttConnectOptions getConOptions() {
        return this.conOptions;
    }

    public Properties getDebug() {
        Properties props = new Properties();
        props.put("conState", new Integer(this.conState));
        props.put("serverURI", this.getClient().getServerURI());
        props.put("callback", this.callback);
        props.put("stoppingComms", new Boolean(this.stoppingComms));
        return props;
    }

    private class DisconnectBG
    implements Runnable {
        Thread dBg = null;
        MqttDisconnect disconnect;
        long quiesceTimeout;
        MqttToken token;

        DisconnectBG(MqttDisconnect disconnect, long quiesceTimeout, MqttToken token) {
            this.disconnect = disconnect;
            this.quiesceTimeout = quiesceTimeout;
            this.token = token;
        }

        void start() {
            this.dBg = new Thread((Runnable)this, "MQTT Disc: " + ClientComms.this.getClient().getClientId());
            this.dBg.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String methodName = "disconnectBG:run";
            ClientComms.this.log.fine(className, "disconnectBG:run", "221");
            ClientComms.this.clientState.quiesce(this.quiesceTimeout);
            try {
                ClientComms.this.internalSend(this.disconnect, this.token);
                this.token.internalTok.waitUntilSent();
            }
            catch (MqttException mqttException) {
            }
            finally {
                this.token.internalTok.markComplete(null, null);
                ClientComms.this.shutdownConnection(this.token, null);
            }
        }
    }

    private class ConnectBG
    implements Runnable {
        ClientComms clientComms = null;
        Thread cBg = null;
        MqttToken conToken;
        MqttConnect conPacket;

        ConnectBG(ClientComms cc, MqttToken cToken, MqttConnect cPacket) {
            this.clientComms = cc;
            this.conToken = cToken;
            this.conPacket = cPacket;
            this.cBg = new Thread((Runnable)this, "MQTT Con: " + ClientComms.this.getClient().getClientId());
        }

        void start() {
            this.cBg.start();
        }

        @Override
        public void run() {
            String methodName = "connectBG:run";
            MqttException mqttEx = null;
            ClientComms.this.log.fine(className, "connectBG:run", "220");
            try {
                MqttDeliveryToken[] toks = ClientComms.this.tokenStore.getOutstandingDelTokens();
                for (int i = 0; i < toks.length; ++i) {
                    toks[i].internalTok.setException(null);
                }
                ClientComms.this.tokenStore.saveToken(this.conToken, this.conPacket);
                NetworkModule networkModule = ClientComms.this.networkModules[ClientComms.this.networkModuleIndex];
                networkModule.start();
                ClientComms.this.receiver = new CommsReceiver(this.clientComms, ClientComms.this.clientState, ClientComms.this.tokenStore, networkModule.getInputStream());
                ClientComms.this.receiver.start("MQTT Rec: " + ClientComms.this.getClient().getClientId());
                ClientComms.this.sender = new CommsSender(this.clientComms, ClientComms.this.clientState, ClientComms.this.tokenStore, networkModule.getOutputStream());
                ClientComms.this.sender.start("MQTT Snd: " + ClientComms.this.getClient().getClientId());
                ClientComms.this.callback.start("MQTT Call: " + ClientComms.this.getClient().getClientId());
                ClientComms.this.internalSend(this.conPacket, this.conToken);
            }
            catch (MqttException ex) {
                ClientComms.this.log.fine(className, "connectBG:run", "212", null, ex);
                mqttEx = ex;
            }
            catch (Exception ex) {
                ClientComms.this.log.fine(className, "connectBG:run", "209", null, ex);
                mqttEx = ExceptionHelper.createMqttException(ex);
            }
            if (mqttEx != null) {
                ClientComms.this.shutdownConnection(this.conToken, mqttEx);
            }
        }
    }
}

