/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.bfcy.base.LogActivity;
import com.bfcy.base.utils.CommonUtils;
import java.util.ArrayList;

public class BaseActivity
extends LogActivity {
    public String TAG = ((Object)((Object)this)).getClass().getSimpleName();
    private static final int RUNTIME_PERMISSION_REQUEST_CODE = 1;
    private RuntimePermissionListener mRuntimePermissionListener;

    public void checkRuntimePermission(String[] permissions, RuntimePermissionListener runtimePermissionListener) {
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        this.mRuntimePermissionListener = runtimePermissionListener;
        ArrayList<String> deniedPermissionList = new ArrayList<String>();
        for (String permission : permissions) {
            if (ContextCompat.checkSelfPermission((Context)this, (String)permission) == 0) continue;
            deniedPermissionList.add(permission);
        }
        if (deniedPermissionList.isEmpty()) {
            this.mRuntimePermissionListener.onRuntimePermissionGranted();
        } else {
            String[] deniedPermissionArray = deniedPermissionList.toArray(new String[0]);
            ActivityCompat.requestPermissions((Activity)this, (String[])deniedPermissionArray, (int)1);
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        switch (requestCode) {
            case 1: {
                if (grantResults.length <= 0) break;
                ArrayList<String> deniedPermissionList = new ArrayList<String>();
                for (int i = 0; i < grantResults.length; ++i) {
                    if (grantResults[i] == 0) continue;
                    deniedPermissionList.add(permissions[i]);
                }
                if (deniedPermissionList.isEmpty()) {
                    this.mRuntimePermissionListener.onRuntimePermissionGranted();
                    break;
                }
                this.mRuntimePermissionListener.onRuntimePermissionDenied();
            }
        }
    }

    private boolean show(String permission) {
        return ActivityCompat.shouldShowRequestPermissionRationale((Activity)this, (String)permission);
    }

    public void jumpTo(Class<? extends Activity> clz) {
        Intent intent = new Intent((Context)this, clz);
        this.startActivity(intent);
    }

    public void jumpTo(Class<? extends Activity> clz, Bundle bundle) {
        Intent intent = new Intent((Context)this, clz);
        intent.putExtras(bundle);
        this.startActivity(intent);
    }

    public void jumpToForResult(Class<? extends Activity> clz, int requestCode) {
        Intent intent = new Intent((Context)this, clz);
        this.startActivityForResult(intent, requestCode);
    }

    public void jumpToForResult(Class<? extends Activity> clz, int requestCode, Bundle bundle) {
        Intent intent = new Intent((Context)this, clz);
        intent.putExtras(bundle);
        this.startActivityForResult(intent, requestCode, bundle);
    }

    public void showToast(String msg) {
        CommonUtils.showToast(msg);
    }

    public void showToast(int resId) {
        CommonUtils.showToast(resId);
    }

    public void showToast(String msg, int length) {
        CommonUtils.showToast(msg, length);
    }

    public void showToast(int resI, int length) {
        CommonUtils.showToast(resI, length);
    }

    public void showImageToast(int iconResId, String tips) {
        CommonUtils.showImageToast(iconResId, tips);
    }

    public void showImageToast(int iconResId, int tipsResId) {
        CommonUtils.showImageToast(iconResId, tipsResId);
        this.showImageToast(iconResId, this.getString(tipsResId), 0);
    }

    public void showImageToast(int iconResId, int tipsResId, int length) {
        CommonUtils.showImageToast(iconResId, tipsResId, length);
    }

    public void showImageToast(int iconResId, String tips, int length) {
        CommonUtils.showImageToast(iconResId, tips, length);
    }

    public static interface RuntimePermissionListener {
        public void onRuntimePermissionGranted();

        public void onRuntimePermissionDenied();
    }
}

