/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatDelegate;
import com.bfcy.base.BaseActivity;
import com.bfcy.base.BaseApp;
import com.bfcy.base.R;
import com.bfcy.base.utils.ActivityDequeManager;
import com.bfcy.base.utils.LanguageUtil;
import com.bfcy.base.utils.SPUtil;
import com.bfcy.base.utils.StatusBarUtils;
import com.bfcy.base.utils.ThemeUtil;
import com.lxj.statelayout.StateLayout;

public class BaseAppActivity
extends BaseActivity {
    protected int type = 1;
    protected boolean isLightMode = false;
    protected int backStyle = 1;
    protected int deleteStyle = 1;
    protected int searchStyle = 1;
    protected int settingsStyle = 1;
    protected int moreStyle = 1;
    protected View.OnClickListener backListener;
    public StateLayout stateLayout;
    public int defaultTheme = 2;

    public void setBackListener(View.OnClickListener backListener) {
        this.backListener = backListener;
    }

    protected void initData() {
    }

    protected void initView() {
    }

    protected void setStatusBar(boolean isLight, int color) {
        if (isLight) {
            StatusBarUtils.setStatusBarMode((Activity)this, true);
            if (color != 0) {
                StatusBarUtils.setStatusBarColor((Activity)this, color);
            } else {
                StatusBarUtils.setStatusBarColor((Activity)this, ThemeUtil.getThemeColor((Context)this, R.attr.themeColorStatusBarLight));
            }
        } else {
            StatusBarUtils.setStatusBarMode((Activity)this, false);
            if (color != 0) {
                StatusBarUtils.setStatusBarColor((Activity)this, color);
            } else {
                StatusBarUtils.setStatusBarColor((Activity)this, ThemeUtil.getThemeColor((Context)this, R.attr.themeColorStatusBar));
            }
        }
    }

    private void changeTheme() {
        int theme = SPUtil.getInstance((Context)this).getThemeType(this.defaultTheme);
        if (theme == 0) {
            AppCompatDelegate.setDefaultNightMode((int)-1);
            this.setTheme(R.style.AppTheme_Default);
            ThemeUtil.isSupportLightMode = (this.getResources().getConfiguration().uiMode & 0x30) != 32;
        } else {
            AppCompatDelegate.setDefaultNightMode((int)1);
            ThemeUtil.isSupportLightMode = true;
            if (theme == 1) {
                this.setTheme(R.style.AppTheme_Dark);
                ThemeUtil.isSupportLightMode = false;
            } else if (theme == 2) {
                this.setTheme(R.style.AppTheme_Purple);
            } else if (theme == 3) {
                this.setTheme(R.style.AppTheme_Blue);
            } else {
                this.setTheme(R.style.AppTheme_Default);
            }
        }
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.changeTheme();
        ActivityDequeManager.getInstance().addActivity((Activity)this);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        ActivityDequeManager.getInstance().removeActivity((Activity)this);
    }

    protected void attachBaseContext(Context newBase) {
        String language = SPUtil.getInstance((Context)BaseApp.getInstance()).getString("selected_language");
        super.attachBaseContext(LanguageUtil.attachBaseContext(newBase, language));
    }
}

