/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.viewbinding.ViewBinding;
import com.bfcy.base.BaseAppActivity;
import com.bfcy.base.BaseTitleInterface;
import com.bfcy.base.databinding.TitleBarBaseBinding;
import com.bfcy.base.utils.ThemeUtil;
import com.bfcy.base.utils.TitleBarUtil;
import com.lxj.statelayout.StateLayout;

public abstract class BaseBindingActivity<VB extends ViewBinding>
extends BaseAppActivity
implements BaseTitleInterface {
    @Nullable
    public TitleBarBaseBinding titleBinding;
    @NonNull
    public VB binding;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.binding = this.getViewBinding();
        this.titleBinding = this.getTitleBinding();
        this.setContentView(this.binding.getRoot());
        this.stateLayout = new StateLayout((Context)this).config(null, null, null, null, null, Boolean.valueOf(true), null, null, null, null, null, null, null);
        this.initData();
        this.setTitleBar();
        this.initView();
    }

    protected abstract VB getViewBinding();

    @Nullable
    protected abstract TitleBarBaseBinding getTitleBinding();

    @Override
    public void showTitleBar(boolean show) {
        if (this.titleBinding != null) {
            if (show) {
                this.titleBinding.layoutTitleBar.setVisibility(0);
            } else {
                this.titleBinding.layoutTitleBar.setVisibility(8);
            }
        }
    }

    @Override
    public void setTitleBar() {
        this.setTitleBar(this.isLightMode);
    }

    @Override
    public void setTitleBar(boolean isLight) {
        this.setTitleBar(isLight, 0);
    }

    @Override
    public void setTitleBar(boolean isLight, int color) {
        this.setTitleBar(isLight, color, color);
    }

    @Override
    public void setTitleBar(boolean isLight, int titleBarColor, int statusBarColor) {
        this.isLightMode = isLight;
        this.setStatusBar(this.isLightMode && ThemeUtil.isSupportLightMode, statusBarColor);
        if (this.titleBinding == null) {
            return;
        }
        if (this.backListener != null) {
            this.titleBinding.ivBack.setOnClickListener(this.backListener);
        } else {
            this.titleBinding.ivBack.setOnClickListener(v -> this.finish());
        }
        TitleBarUtil.initTitleBar((Context)this, this.isLightMode && ThemeUtil.isSupportLightMode, titleBarColor, (View)this.titleBinding.layoutTitleBar, this.titleBinding.ivBack, this.titleBinding.ivDelete, this.titleBinding.tvStartTitle, this.titleBinding.tvBackStartTitle, this.titleBinding.tvTitle, this.titleBinding.tvRightText);
    }

    @Override
    public void setTitle(CharSequence title) {
        this.setMiddleTitle(title);
    }

    @Override
    public void setTitle(@StringRes int stringId) {
        this.setMiddleTitle(stringId);
    }

    @Override
    public void setMiddleTitle(CharSequence title) {
        if (this.titleBinding == null) {
            return;
        }
        this.titleBinding.tvTitle.setText(title);
    }

    @Override
    public void setMiddleTitle(@StringRes int titleStringRes) {
        if (this.titleBinding == null) {
            return;
        }
        this.titleBinding.tvTitle.setText(titleStringRes);
    }

    @Override
    public void setStartTitle(CharSequence title) {
        this.showBack(false);
        if (this.titleBinding == null) {
            return;
        }
        this.titleBinding.tvStartTitle.setText(title);
    }

    @Override
    public void setStartTitle(@StringRes int titleStringRes) {
        this.showBack(false);
        if (this.titleBinding == null) {
            return;
        }
        this.titleBinding.tvStartTitle.setText(titleStringRes);
    }

    @Override
    public void setBackStartTitle(CharSequence title) {
        if (this.titleBinding == null) {
            return;
        }
        this.titleBinding.tvBackStartTitle.setText(title);
    }

    @Override
    public void setBackStartTitle(@StringRes int titleStringRes) {
        if (this.titleBinding == null) {
            return;
        }
        this.titleBinding.tvBackStartTitle.setText(titleStringRes);
    }

    @Override
    public void showBack(boolean show) {
        if (this.titleBinding == null) {
            return;
        }
        if (show) {
            this.titleBinding.ivBack.setVisibility(0);
        } else {
            this.titleBinding.ivBack.setVisibility(8);
        }
    }

    @Override
    public void setBackStyle(int style2) {
        this.backStyle = style2;
        if (this.titleBinding != null) {
            TitleBarUtil.setBackStyle(this.isLightMode && ThemeUtil.isSupportLightMode, this.titleBinding.ivBack, this.backStyle);
        }
    }

    @Override
    public void showDelete(boolean show) {
        if (this.titleBinding != null) {
            if (show) {
                this.titleBinding.ivDelete.setVisibility(0);
            } else {
                this.titleBinding.ivDelete.setVisibility(8);
            }
        }
    }

    @Override
    public void setDeleteStyle(int style2) {
        this.deleteStyle = style2;
        if (this.titleBinding != null) {
            TitleBarUtil.setDeleteStyle(this.isLightMode && ThemeUtil.isSupportLightMode, this.titleBinding.ivDelete, this.deleteStyle);
        }
    }

    @Override
    public void showSearch(boolean show) {
        if (this.titleBinding != null) {
            if (show) {
                this.titleBinding.ivSearch.setVisibility(0);
                this.setSearchStyle(this.searchStyle);
            } else {
                this.titleBinding.ivSearch.setVisibility(8);
            }
        }
    }

    @Override
    public void setSearchStyle(int style2) {
        this.searchStyle = style2;
        if (this.titleBinding != null) {
            TitleBarUtil.setSearchType(this.isLightMode && ThemeUtil.isSupportLightMode, this.titleBinding.ivSearch, this.searchStyle);
        }
    }

    @Override
    public void showSettings(boolean show) {
        if (this.titleBinding != null) {
            if (show) {
                this.titleBinding.ivSettings.setVisibility(0);
                this.setSettingsStyle(this.settingsStyle);
            } else {
                this.titleBinding.ivSettings.setVisibility(8);
            }
        }
    }

    @Override
    public void setSettingsStyle(int style2) {
        this.settingsStyle = style2;
        if (this.titleBinding != null) {
            TitleBarUtil.setSettingsType(this.isLightMode && ThemeUtil.isSupportLightMode, this.titleBinding.ivSettings, this.settingsStyle);
        }
    }

    @Override
    public void showMore(boolean show) {
        if (this.titleBinding != null) {
            if (show) {
                this.titleBinding.ivMore.setVisibility(0);
                this.setMoreStyle(this.moreStyle);
            } else {
                this.titleBinding.ivMore.setVisibility(8);
            }
        }
    }

    @Override
    public void setMoreStyle(int style2) {
        this.moreStyle = style2;
        if (this.titleBinding != null) {
            TitleBarUtil.setMoreStyle(this.isLightMode && ThemeUtil.isSupportLightMode, this.titleBinding.ivMore, this.moreStyle);
        }
    }
}

