/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.viewbinding.ViewBinding;
import com.bfcy.base.BaseAppActivity;
import com.bfcy.base.BaseTitleInterface;
import com.bfcy.base.databinding.ActivityTitleBarBaseBinding;
import com.bfcy.base.utils.ThemeUtil;
import com.bfcy.base.utils.TitleBarUtil;
import com.lxj.statelayout.StateLayout;

public abstract class BaseBindingTitleActivity<VB extends ViewBinding>
extends BaseAppActivity
implements BaseTitleInterface {
    public ActivityTitleBarBaseBinding baseBinding;
    @NonNull
    public VB binding;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.baseBinding = ActivityTitleBarBaseBinding.inflate(this.getLayoutInflater());
        this.binding = this.getViewBinding();
        this.setContentView((View)this.baseBinding.getRoot());
        this.stateLayout = new StateLayout((Context)this).config(null, null, null, null, null, Boolean.valueOf(true), null, null, null, null, null, null, null);
        this.initData();
        this.setTitleBar();
        this.initView();
    }

    @NonNull
    protected abstract VB getViewBinding();

    @Override
    public void showTitleBar(boolean show) {
        if (show) {
            this.baseBinding.titleBarBase.layoutTitleBar.setVisibility(0);
        } else {
            this.baseBinding.titleBarBase.layoutTitleBar.setVisibility(8);
        }
    }

    @Override
    public void setTitleBar() {
        this.setTitleBar(this.isLightMode);
    }

    @Override
    public void setTitleBar(boolean isLight) {
        this.setTitleBar(isLight, 0);
    }

    @Override
    public void setTitleBar(boolean isLight, int color) {
        this.setTitleBar(isLight, color, color);
    }

    @Override
    public void setTitleBar(boolean isLight, int titleBarColor, int statusBarColor) {
        this.isLightMode = isLight;
        this.setStatusBar(this.isLightMode && ThemeUtil.isSupportLightMode, statusBarColor);
        if (this.backListener != null) {
            this.baseBinding.titleBarBase.ivBack.setOnClickListener(this.backListener);
        } else {
            this.baseBinding.titleBarBase.ivBack.setOnClickListener(v -> this.finish());
        }
        TitleBarUtil.initTitleBar((Context)this, this.isLightMode && ThemeUtil.isSupportLightMode, titleBarColor, (View)this.baseBinding.titleBarBase.layoutTitleBar, this.baseBinding.titleBarBase.ivBack, this.baseBinding.titleBarBase.ivDelete, this.baseBinding.titleBarBase.tvStartTitle, this.baseBinding.titleBarBase.tvBackStartTitle, this.baseBinding.titleBarBase.tvTitle, this.baseBinding.titleBarBase.tvRightText);
    }

    @Override
    public void setTitle(CharSequence title) {
        this.setMiddleTitle(title);
    }

    @Override
    public void setTitle(@StringRes int titleStringRes) {
        this.setMiddleTitle(titleStringRes);
    }

    @Override
    public void setMiddleTitle(CharSequence title) {
        this.baseBinding.titleBarBase.tvTitle.setText(title);
    }

    @Override
    public void setMiddleTitle(@StringRes int titleStringRes) {
        this.baseBinding.titleBarBase.tvTitle.setText(titleStringRes);
    }

    @Override
    public void setStartTitle(CharSequence title) {
        this.showBack(false);
        this.baseBinding.titleBarBase.tvStartTitle.setText(title);
    }

    @Override
    public void setStartTitle(@StringRes int titleStringRes) {
        this.showBack(false);
        this.baseBinding.titleBarBase.tvStartTitle.setText(titleStringRes);
    }

    @Override
    public void setBackStartTitle(CharSequence title) {
        this.baseBinding.titleBarBase.tvBackStartTitle.setText(title);
    }

    @Override
    public void setBackStartTitle(@StringRes int titleStringRes) {
        this.baseBinding.titleBarBase.tvBackStartTitle.setText(titleStringRes);
    }

    @Override
    public void showBack(boolean show) {
        if (show) {
            this.baseBinding.titleBarBase.ivBack.setVisibility(0);
        } else {
            this.baseBinding.titleBarBase.ivBack.setVisibility(8);
        }
    }

    @Override
    public void setBackStyle(int style2) {
        this.backStyle = style2;
        TitleBarUtil.setBackStyle(this.isLightMode && ThemeUtil.isSupportLightMode, this.baseBinding.titleBarBase.ivBack, this.backStyle);
    }

    @Override
    public void showDelete(boolean show) {
        if (show) {
            this.baseBinding.titleBarBase.ivDelete.setVisibility(0);
        } else {
            this.baseBinding.titleBarBase.ivDelete.setVisibility(8);
        }
    }

    @Override
    public void setDeleteStyle(int style2) {
        this.deleteStyle = style2;
        TitleBarUtil.setDeleteStyle(this.isLightMode && ThemeUtil.isSupportLightMode, this.baseBinding.titleBarBase.ivDelete, this.deleteStyle);
    }

    @Override
    public void showSearch(boolean show) {
        if (show) {
            this.baseBinding.titleBarBase.ivSearch.setVisibility(0);
            this.setSearchStyle(this.searchStyle);
        } else {
            this.baseBinding.titleBarBase.ivSearch.setVisibility(8);
        }
    }

    @Override
    public void setSearchStyle(int style2) {
        this.searchStyle = style2;
        TitleBarUtil.setSearchType(this.isLightMode && ThemeUtil.isSupportLightMode, this.baseBinding.titleBarBase.ivSearch, this.searchStyle);
    }

    @Override
    public void showSettings(boolean show) {
        if (show) {
            this.baseBinding.titleBarBase.ivSettings.setVisibility(0);
            this.setSettingsStyle(this.settingsStyle);
        } else {
            this.baseBinding.titleBarBase.ivSettings.setVisibility(8);
        }
    }

    @Override
    public void setSettingsStyle(int style2) {
        this.settingsStyle = style2;
        TitleBarUtil.setSettingsType(this.isLightMode && ThemeUtil.isSupportLightMode, this.baseBinding.titleBarBase.ivSettings, this.settingsStyle);
    }

    @Override
    public void showMore(boolean show) {
        if (show) {
            this.baseBinding.titleBarBase.ivMore.setVisibility(0);
            this.setMoreStyle(this.moreStyle);
        } else {
            this.baseBinding.titleBarBase.ivMore.setVisibility(8);
        }
    }

    @Override
    public void setMoreStyle(int style2) {
        this.moreStyle = style2;
        TitleBarUtil.setMoreStyle(this.isLightMode && ThemeUtil.isSupportLightMode, this.baseBinding.titleBarBase.ivMore, this.moreStyle);
    }
}

