/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.bfcy.base.BaseAppActivity;
import com.bfcy.base.BaseTitleInterface;
import com.bfcy.base.R;
import com.bfcy.base.utils.ThemeUtil;
import com.bfcy.base.utils.TitleBarUtil;
import com.lxj.statelayout.StateLayout;

public class BaseTitleActivity
extends BaseAppActivity
implements BaseTitleInterface {
    public ViewGroup baseView;
    public View layoutTitleBar;
    public ImageView ivBack;
    public TextView tvStartTitle;
    public TextView tvBackStartTitle;
    public TextView tvTitle;
    public ImageView ivDelete;
    public TextView tvRightText;
    public ImageView ivSearch;
    public ImageView ivSettings;
    public ImageView ivMore;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    public void setContentView(int layoutResID) {
        this.baseView = (ViewGroup)this.getLayoutInflater().inflate(R.layout.activity_title_bar_base, null);
        this.getLayoutInflater().inflate(layoutResID, this.baseView, true);
        super.setContentView((View)this.baseView);
        this.baseInit();
    }

    public void setContentView(View view) {
        this.baseView = (ViewGroup)this.getLayoutInflater().inflate(R.layout.activity_title_bar_base, null);
        this.baseView.addView(view);
        super.setContentView((View)this.baseView);
        this.baseInit();
    }

    private void baseInit() {
        this.initTitleView();
        this.initStateLayout();
        this.initData();
        this.initView();
    }

    private void initStateLayout() {
        this.stateLayout = new StateLayout((Context)this).config(null, null, null, null, null, Boolean.valueOf(true), null, null, null, null, null, null, null);
    }

    private void initTitleView() {
        this.layoutTitleBar = this.findViewById(R.id.layoutTitleBar);
        if (this.layoutTitleBar == null) {
            this.layoutTitleBar = this.findViewById(R.id.titleBarBase);
        }
        this.ivBack = (ImageView)this.findViewById(R.id.ivBack);
        this.tvStartTitle = (TextView)this.findViewById(R.id.tvStartTitle);
        this.tvBackStartTitle = (TextView)this.findViewById(R.id.tvBackStartTitle);
        this.tvTitle = (TextView)this.findViewById(R.id.tvTitle);
        this.ivDelete = (ImageView)this.findViewById(R.id.ivDelete);
        this.tvRightText = (TextView)this.findViewById(R.id.tvRightText);
        this.ivSearch = (ImageView)this.findViewById(R.id.ivSearch);
        this.ivSettings = (ImageView)this.findViewById(R.id.ivSettings);
        this.ivMore = (ImageView)this.findViewById(R.id.ivMore);
        this.setTitleBar();
    }

    @Override
    public void showTitleBar(boolean show) {
        if (this.layoutTitleBar != null) {
            if (show) {
                this.layoutTitleBar.setVisibility(0);
            } else {
                this.layoutTitleBar.setVisibility(8);
            }
        }
    }

    @Override
    public void setTitleBar() {
        this.setTitleBar(this.isLightMode);
    }

    @Override
    public void setTitleBar(boolean isLight) {
        this.setTitleBar(isLight, 0);
    }

    @Override
    public void setTitleBar(boolean isLight, int color) {
        this.setTitleBar(isLight, color, color);
    }

    @Override
    public void setTitleBar(boolean isLight, int titleBarColor, int statusBarColor) {
        this.isLightMode = isLight;
        this.setStatusBar(this.isLightMode && ThemeUtil.isSupportLightMode, statusBarColor);
        if (this.ivBack == null || this.layoutTitleBar == null || this.tvTitle == null) {
            return;
        }
        if (this.backListener != null) {
            this.ivBack.setOnClickListener(this.backListener);
        } else {
            this.ivBack.setOnClickListener(v -> this.finish());
        }
        TitleBarUtil.initTitleBar((Context)this, this.isLightMode && ThemeUtil.isSupportLightMode, titleBarColor, this.layoutTitleBar, this.ivBack, this.ivDelete, this.tvStartTitle, this.tvBackStartTitle, this.tvTitle, this.tvRightText);
    }

    @Override
    public void setTitle(CharSequence title) {
        this.setMiddleTitle(title);
    }

    @Override
    public void setTitle(int titleStringRes) {
        this.setMiddleTitle(titleStringRes);
    }

    @Override
    public void setMiddleTitle(CharSequence title) {
        if (this.tvTitle != null) {
            this.tvTitle.setText(title);
        }
    }

    @Override
    public void setMiddleTitle(int titleStringRes) {
        if (this.tvTitle != null) {
            this.tvTitle.setText(titleStringRes);
        }
    }

    @Override
    public void setStartTitle(CharSequence title) {
        this.showBack(false);
        if (this.tvStartTitle != null) {
            this.tvStartTitle.setText(title);
        }
    }

    @Override
    public void setStartTitle(int titleStringRes) {
        this.showBack(false);
        if (this.tvStartTitle != null) {
            this.tvStartTitle.setText(titleStringRes);
        }
    }

    @Override
    public void setBackStartTitle(CharSequence title) {
        if (this.tvBackStartTitle != null) {
            this.tvBackStartTitle.setText(title);
        }
    }

    @Override
    public void setBackStartTitle(int titleStringRes) {
        if (this.tvBackStartTitle != null) {
            this.tvBackStartTitle.setText(titleStringRes);
        }
    }

    @Override
    public void showBack(boolean show) {
        if (this.ivBack != null) {
            if (show) {
                this.ivBack.setVisibility(0);
            } else {
                this.ivBack.setVisibility(8);
            }
        }
    }

    @Override
    public void setBackStyle(int style2) {
        this.backStyle = style2;
        TitleBarUtil.setBackStyle(this.isLightMode && ThemeUtil.isSupportLightMode, this.ivBack, this.backStyle);
    }

    @Override
    public void showDelete(boolean show) {
        if (this.ivDelete != null) {
            if (show) {
                this.ivDelete.setVisibility(0);
            } else {
                this.ivDelete.setVisibility(8);
            }
        }
    }

    @Override
    public void setDeleteStyle(int style2) {
        this.deleteStyle = style2;
        TitleBarUtil.setDeleteStyle(this.isLightMode && ThemeUtil.isSupportLightMode, this.ivDelete, this.deleteStyle);
    }

    @Override
    public void showSearch(boolean show) {
        if (this.ivSearch != null) {
            if (show) {
                this.ivSearch.setVisibility(0);
                this.setSearchStyle(this.searchStyle);
            } else {
                this.ivSearch.setVisibility(8);
            }
        }
    }

    @Override
    public void setSearchStyle(int style2) {
        this.searchStyle = style2;
        TitleBarUtil.setSearchType(this.isLightMode && ThemeUtil.isSupportLightMode, this.ivSearch, this.searchStyle);
    }

    @Override
    public void showSettings(boolean show) {
        if (this.ivSettings != null) {
            if (show) {
                this.ivSettings.setVisibility(0);
                this.setSettingsStyle(this.settingsStyle);
            } else {
                this.ivSettings.setVisibility(8);
            }
        }
    }

    @Override
    public void setSettingsStyle(int style2) {
        this.settingsStyle = style2;
        TitleBarUtil.setSettingsType(this.isLightMode && ThemeUtil.isSupportLightMode, this.ivSettings, this.settingsStyle);
    }

    @Override
    public void showMore(boolean show) {
        if (this.ivMore != null) {
            if (show) {
                this.ivMore.setVisibility(0);
                this.setMoreStyle(this.moreStyle);
            } else {
                this.ivMore.setVisibility(8);
            }
        }
    }

    @Override
    public void setMoreStyle(int style2) {
        this.moreStyle = style2;
        TitleBarUtil.setMoreStyle(this.isLightMode && ThemeUtil.isSupportLightMode, this.ivMore, this.moreStyle);
    }
}

