/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.activity;

import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import com.bfcy.base.R;
import com.bfcy.base.activity.ActivityB;
import com.bfcy.base.log.Logger;

public class ActivityA
extends AppCompatActivity {
    private final String TAG = ((Object)((Object)this)).getClass().getSimpleName();
    private int age = 18;
    private String name = "Tom";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_a);
        Logger.i(this.TAG, "--->Lifecycle: onCreate");
        this.findViewById(R.id.btnJump).setOnClickListener(v -> {
            Intent intent = new Intent((Context)this, ActivityB.class);
            this.startActivity(intent);
        });
        this.findViewById(R.id.btnOrientation).setOnClickListener(v -> {
            if (this.getRequestedOrientation() == 0) {
                this.setRequestedOrientation(1);
            } else if (this.getRequestedOrientation() == 1) {
                this.setRequestedOrientation(0);
            }
        });
        TextView textAge = (TextView)this.findViewById(R.id.textAge);
        textAge.setText((CharSequence)String.valueOf(this.age));
        this.findViewById(R.id.btnPlus).setOnClickListener(v -> {
            textAge.setText((CharSequence)String.valueOf(++this.age));
            this.name = this.name + "-m";
        });
        if (savedInstanceState != null) {
            this.age = savedInstanceState.getInt("age");
            this.name = savedInstanceState.getString("name");
        }
    }

    protected void onRestart() {
        super.onRestart();
        Logger.i(this.TAG, "--->Lifecycle: onRestart");
    }

    protected void onStart() {
        super.onStart();
        Logger.i(this.TAG, "--->Lifecycle: onStart");
    }

    protected void onResume() {
        super.onResume();
        Logger.i(this.TAG, "--->Lifecycle: onResume");
        Logger.i(this.TAG, "--->Lifecycle: onResume--age--" + this.age);
        Logger.i(this.TAG, "--->Lifecycle: onResume--name--" + this.name);
    }

    protected void onPause() {
        super.onPause();
        Logger.i(this.TAG, "--->Lifecycle: onPause");
    }

    protected void onStop() {
        super.onStop();
        Logger.i(this.TAG, "--->Lifecycle: onStop");
    }

    protected void onDestroy() {
        super.onDestroy();
        Logger.i(this.TAG, "--->Lifecycle: onDestroy");
    }

    protected void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        Logger.i(this.TAG, "--->Lifecycle: onSaveInstanceState");
        outState.putInt("age", this.age);
        outState.putString("name", this.name);
    }

    protected void onRestoreInstanceState(@NonNull Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        Logger.i(this.TAG, "--->Lifecycle: onRestoreInstanceState");
        this.age = savedInstanceState.getInt("age");
        this.name = savedInstanceState.getString("name");
        Logger.i(this.TAG, "--->Lifecycle: onRestoreInstanceState--age: " + this.age);
        Logger.i(this.TAG, "--->Lifecycle: onRestoreInstanceState--name: " + this.name);
    }

    public void onConfigurationChanged(@NonNull Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (newConfig.orientation == 2 || newConfig.orientation == 1) {
            // empty if block
        }
    }
}

