/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.activity;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import com.bfcy.base.BaseTitleActivity;
import com.bfcy.base.R;
import com.bfcy.base.utils.ToastUtil;

public class CommonWebViewActivity
extends BaseTitleActivity {
    private ProgressBar progressBar;
    private WebView webView;
    private String httpUrl = "";
    private String localPath = "";
    private String localTitle = "";

    public static void newInstance(Context context, String httpUrl) {
        Bundle args = new Bundle();
        args.putString("httpUrl", httpUrl);
        Intent intent = new Intent(context, CommonWebViewActivity.class);
        intent.putExtras(args);
        context.startActivity(intent);
    }

    public static void newInstance(Context context, String localPath, String localTitle) {
        Bundle args = new Bundle();
        args.putString("localPath", localPath);
        args.putString("localTitle", localTitle);
        Intent intent = new Intent(context, CommonWebViewActivity.class);
        intent.putExtras(args);
        context.startActivity(intent);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_common_web_view);
        this.setTitleBar(true);
        this.initData();
        this.initView();
        this.initWebView();
    }

    @Override
    protected void initData() {
        Bundle bundle = this.getIntent().getExtras();
        if (bundle != null) {
            this.httpUrl = bundle.getString("httpUrl");
            this.localPath = bundle.getString("localPath");
            if (!TextUtils.isEmpty((CharSequence)this.localPath)) {
                this.localTitle = bundle.getString("localTitle");
                if (!this.localPath.startsWith("file:///android_asset/")) {
                    this.localPath = "file:///android_asset/" + this.localPath;
                }
            }
        }
    }

    @Override
    protected void initView() {
        this.progressBar = (ProgressBar)this.findViewById(R.id.progressBar);
        this.webView = (WebView)this.findViewById(R.id.webView);
        this.setBackListener(v -> {
            if (this.webView != null && this.webView.canGoBack()) {
                this.webView.goBack();
            } else {
                this.finish();
            }
        });
    }

    private void initWebView() {
        if (!TextUtils.isEmpty((CharSequence)this.httpUrl)) {
            this.webView.loadUrl(this.httpUrl);
        } else if (!TextUtils.isEmpty((CharSequence)this.localPath)) {
            this.webView.loadUrl(this.localPath);
        } else {
            ToastUtil.showToast((Context)this, "URL is empty");
            return;
        }
        this.webView.setScrollBarStyle(0);
        WebSettings webSettings = this.webView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setDefaultTextEncodingName("UTF-8");
        webSettings.setSupportZoom(true);
        webSettings.setBuiltInZoomControls(true);
        webSettings.setUseWideViewPort(true);
        webSettings.setLoadWithOverviewMode(true);
        this.webView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                Log.i((String)"tag", (String)("--->WebView--shouldOverrideUrlLoading--\u5730\u5740\uff1a" + url));
                return false;
            }

            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                return false;
            }

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                Log.i((String)"tag", (String)("--->WebView--onPageStarted--\u5730\u5740\uff1a" + url));
                super.onPageStarted(view, url, favicon);
            }

            public void onPageFinished(WebView view, String url) {
                Log.i((String)"tag", (String)("--->WebView--onPageFinished--\u5730\u5740\uff1a" + url));
                super.onPageFinished(view, url);
            }
        });
        this.webView.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int newProgress) {
                Log.i((String)"tag", (String)("--->WebView--onProgressChanged--newProgress\uff1a" + newProgress));
                if (newProgress < 100) {
                    CommonWebViewActivity.this.progressBar.setVisibility(0);
                    CommonWebViewActivity.this.progressBar.setProgress(newProgress);
                } else {
                    CommonWebViewActivity.this.progressBar.setVisibility(8);
                }
            }

            public void onReceivedTitle(WebView view, String title) {
                Log.i((String)"tag", (String)("--->WebView--onReceivedTitle--title\uff1a" + title));
                super.onReceivedTitle(view, title);
                if (!TextUtils.isEmpty((CharSequence)CommonWebViewActivity.this.localTitle)) {
                    CommonWebViewActivity.this.setTitle(CommonWebViewActivity.this.localTitle);
                }
            }
        });
    }

    public void onBackPressed() {
        if (this.webView != null && this.webView.canGoBack()) {
            this.webView.goBack();
        } else {
            super.onBackPressed();
        }
    }
}

