/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.adapter;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.bfcy.base.R;
import com.bfcy.base.adapter.ItemClickListener;
import com.bfcy.base.beans.CommonItem;
import com.bfcy.base.utils.AdapterUtil;
import com.bfcy.base.utils.ThemeUtil;
import com.bumptech.glide.Glide;
import java.util.ArrayList;
import java.util.List;

public class CommonItemAdapter
extends RecyclerView.Adapter<CommonItemHolder> {
    private final Context context;
    private final List<CommonItem> itemList;
    private int listMode = 0;
    private final int layoutStyle;
    private int checkStyle = 1;
    private ItemClickListener itemClickListener;
    protected boolean isLightMode = true;
    @ColorInt
    private int bgColor;
    @ColorInt
    private int textColor;
    private boolean showDivider = true;

    public List<CommonItem> getItemList() {
        return this.itemList;
    }

    public void setListMode(int listMode) {
        this.listMode = listMode;
    }

    public void setCheckStyle(int checkStyle) {
        this.checkStyle = checkStyle;
    }

    public void setItemClickListener(ItemClickListener itemClickListener) {
        this.itemClickListener = itemClickListener;
    }

    public void setAdapterItem() {
        this.setAdapterItem(true, ThemeUtil.getThemeColor(this.context, R.attr.themeColorBgItem), ThemeUtil.getThemeColor(this.context, R.attr.themeColorFontDark));
    }

    public void setAdapterItem(boolean isLightMode, @ColorInt int bgColor, @ColorInt int textColor) {
        this.isLightMode = isLightMode && ThemeUtil.isSupportLightMode;
        this.bgColor = bgColor;
        this.textColor = textColor;
    }

    public void setShowDivider(boolean showDivider) {
        this.showDivider = showDivider;
    }

    public CommonItemAdapter(Context context, List<CommonItem> itemList) {
        this(context, itemList, 1);
    }

    public CommonItemAdapter(Context context, List<CommonItem> itemList, int layoutStyle) {
        this.context = context;
        this.setAdapterItem();
        this.itemList = itemList;
        this.layoutStyle = layoutStyle;
    }

    @NonNull
    public CommonItemHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (this.layoutStyle == 2) {
            return new CommonItemHolder(LayoutInflater.from((Context)this.context).inflate(R.layout.item_list_common_2, parent, false));
        }
        return new CommonItemHolder(LayoutInflater.from((Context)this.context).inflate(R.layout.item_list_common, parent, false));
    }

    public void onBindViewHolder(@NonNull CommonItemHolder holder, int position) {
        int mPosition = holder.getAdapterPosition();
        AdapterUtil.dealDivider(this.showDivider, (View)holder.tvDivider, mPosition);
        CommonItem item = this.itemList.get(mPosition);
        if (!TextUtils.isEmpty((CharSequence)item.getIconUrl()) || item.getIconRes() != 0) {
            holder.ivIcon.setVisibility(0);
            if (!TextUtils.isEmpty((CharSequence)item.getIconUrl())) {
                Glide.with((Context)this.context).load(item.getIconUrl()).into(holder.ivIcon);
            }
            if (item.getIconRes() != 0) {
                Glide.with((Context)this.context).load(Integer.valueOf(item.getIconRes())).into(holder.ivIcon);
            }
        } else {
            holder.ivIcon.setVisibility(8);
        }
        AdapterUtil.setCheckType(this.isLightMode, holder.ivCheck, item.isChecked(), this.checkStyle);
        holder.tvName.setTextColor(this.textColor);
        holder.tvName.setText((CharSequence)item.getName());
        holder.itemView.setBackgroundColor(this.bgColor);
        holder.itemView.setOnClickListener(v -> {
            this.itemClick(mPosition);
            if (this.itemClickListener != null) {
                this.itemClickListener.onItemClick(item);
            }
        });
        if (this.layoutStyle == 2) {
            holder.tvDivider.setVisibility(8);
        }
    }

    private void itemClick(int position) {
        if (this.listMode == 1) {
            if (!this.itemList.get(position).isChecked()) {
                for (int i = 0; i < this.itemList.size(); ++i) {
                    if (!this.itemList.get(i).isChecked()) continue;
                    this.itemList.get(i).setChecked(false);
                }
                this.itemList.get(position).setChecked(true);
                this.notifyDataSetChanged();
            }
        } else if (this.listMode == 2) {
            this.itemList.get(position).setChecked(!this.itemList.get(position).isChecked());
            this.notifyDataSetChanged();
        } else if (this.listMode == 0) {
            // empty if block
        }
    }

    public List<CommonItem> getCheckedItems() {
        ArrayList<CommonItem> items = new ArrayList<CommonItem>();
        if (this.itemList != null && this.itemList.size() > 0) {
            for (CommonItem item : this.itemList) {
                if (!item.isChecked()) continue;
                items.add(item);
            }
        }
        return items;
    }

    public int getItemCount() {
        return this.itemList.size();
    }

    static class CommonItemHolder
    extends RecyclerView.ViewHolder {
        View itemView;
        ImageView ivIcon;
        TextView tvName;
        TextView tvDivider;
        ImageView ivCheck;

        CommonItemHolder(View itemView) {
            super(itemView);
            this.itemView = itemView;
            this.tvDivider = (TextView)itemView.findViewById(R.id.tvDivider);
            this.ivIcon = (ImageView)itemView.findViewById(R.id.ivIcon);
            this.tvName = (TextView)itemView.findViewById(R.id.tvName);
            this.ivCheck = (ImageView)itemView.findViewById(R.id.ivCheck);
        }
    }
}

