/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.adapter;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.bfcy.base.R;
import com.bfcy.base.beans.Title;
import com.bfcy.base.utils.ThemeUtil;
import java.util.List;

public class TitleAdapter
extends RecyclerView.Adapter<TitleHolder> {
    private final Context context;
    private final List<Title> titleList;
    private int titleStyle = 1;
    private int bgColor;
    private int textColor;

    public void setTitleStyle(int titleStyle) {
        this.titleStyle = titleStyle;
    }

    public void setTitleStyle(int titleStyle, @ColorInt int bgColor, @ColorInt int textColor) {
        this.titleStyle = titleStyle;
        this.bgColor = bgColor;
        this.textColor = textColor;
    }

    public TitleAdapter(Context context, List<Title> titleList) {
        this.context = context;
        this.titleList = titleList;
    }

    @NonNull
    public TitleHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new TitleHolder(LayoutInflater.from((Context)this.context).inflate(R.layout.item_list_text, parent, false));
    }

    public void onBindViewHolder(@NonNull TitleHolder holder, int position) {
        int mPosition = holder.getAdapterPosition();
        Title title = this.titleList.get(mPosition);
        if (this.titleStyle == 0) {
            holder.name.setTextColor(this.textColor);
            holder.name.setBackgroundColor(this.bgColor);
        } else if (this.titleStyle == 3) {
            holder.name.setTextColor(ThemeUtil.getThemeColor(this.context, R.attr.themeColorFontDark));
            holder.name.setBackgroundColor(ThemeUtil.getThemeColor(this.context, R.attr.themeColorBgItem));
        } else if (this.titleStyle == 2) {
            holder.name.setTextColor(this.context.getResources().getColor(R.color.white));
            holder.name.setBackgroundColor(ThemeUtil.getThemeColor(this.context, R.attr.themeColorBgBtn));
        } else {
            holder.name.setTextColor(this.context.getResources().getColor(R.color.white));
            holder.name.setBackgroundColor(ThemeUtil.getThemeColor(this.context, R.attr.themeColorMain));
        }
        holder.name.setText((CharSequence)title.getName());
        holder.itemView.setOnClickListener(v -> {
            Intent intent = new Intent(this.context, title.getClz());
            Bundle bundle = new Bundle();
            bundle.putInt("type", title.getType());
            intent.putExtras(bundle);
            this.context.startActivity(intent);
        });
    }

    public int getItemCount() {
        return this.titleList.size();
    }

    static class TitleHolder
    extends RecyclerView.ViewHolder {
        View itemView;
        TextView name;

        TitleHolder(View itemView) {
            super(itemView);
            this.itemView = itemView;
            this.name = (TextView)itemView.findViewById(R.id.textView);
        }
    }
}

