/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.encrypt;

import android.os.Build;
import android.text.TextUtils;
import com.bfcy.base.encrypt.Base64Decoder;
import com.bfcy.base.encrypt.Base64Encoder;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AesUtil {
    private static final String HEX = "0123456789ABCDEF";
    private static final String CBC_PKCS5_PADDING = "AES/CBC/PKCS5Padding";
    private static final String AES = "AES";
    private static final String SHA1PRNG = "SHA1PRNG";

    public static String encrypt(String key, String cleartext) {
        if (TextUtils.isEmpty((CharSequence)cleartext)) {
            return cleartext;
        }
        try {
            byte[] result = AesUtil.encrypt(key, cleartext.getBytes());
            return Base64Encoder.encode(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static byte[] encrypt(String key, byte[] clear) throws Exception {
        byte[] raw = AesUtil.getRawKey(key.getBytes());
        SecretKeySpec skeySpec = new SecretKeySpec(raw, AES);
        Cipher cipher = Cipher.getInstance(CBC_PKCS5_PADDING);
        cipher.init(1, (Key)skeySpec, new IvParameterSpec(new byte[cipher.getBlockSize()]));
        byte[] encrypted = cipher.doFinal(clear);
        return encrypted;
    }

    public static String decrypt(String key, String encrypted) {
        if (TextUtils.isEmpty((CharSequence)encrypted)) {
            return encrypted;
        }
        try {
            byte[] enc = Base64Decoder.decodeToBytes(encrypted);
            byte[] result = AesUtil.decrypt(key, enc);
            return new String(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static byte[] decrypt(String key, byte[] encrypted) throws Exception {
        byte[] raw = AesUtil.getRawKey(key.getBytes());
        SecretKeySpec skeySpec = new SecretKeySpec(raw, AES);
        Cipher cipher = Cipher.getInstance(CBC_PKCS5_PADDING);
        cipher.init(2, (Key)skeySpec, new IvParameterSpec(new byte[cipher.getBlockSize()]));
        byte[] decrypted = cipher.doFinal(encrypted);
        return decrypted;
    }

    public static String generateKey() {
        try {
            SecureRandom localSecureRandom = SecureRandom.getInstance(SHA1PRNG);
            byte[] bytes_key = new byte[20];
            localSecureRandom.nextBytes(bytes_key);
            String str_key = AesUtil.toHex(bytes_key);
            return str_key;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String toHex(byte[] buf) {
        if (buf == null) {
            return "";
        }
        StringBuffer result = new StringBuffer(2 * buf.length);
        for (int i = 0; i < buf.length; ++i) {
            AesUtil.appendHex(result, buf[i]);
        }
        return result.toString();
    }

    private static void appendHex(StringBuffer sb, byte b) {
        sb.append(HEX.charAt(b >> 4 & 0xF)).append(HEX.charAt(b & 0xF));
    }

    private static byte[] getRawKey(byte[] seed) throws Exception {
        KeyGenerator kgen = KeyGenerator.getInstance(AES);
        SecureRandom sr = null;
        sr = Build.VERSION.SDK_INT >= 17 ? SecureRandom.getInstance(SHA1PRNG, "Crypto") : SecureRandom.getInstance(SHA1PRNG);
        sr.setSeed(seed);
        kgen.init(128, sr);
        SecretKey skey = kgen.generateKey();
        byte[] raw = skey.getEncoded();
        return raw;
    }
}

