/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.encrypt;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Base64Encoder
extends FilterOutputStream {
    private static final char[] chars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private int charCount;
    private int carryOver;
    private boolean isWrapBreak = true;

    private Base64Encoder(OutputStream out) {
        super(out);
    }

    private Base64Encoder(OutputStream out, boolean isWrapBreak) {
        this(out);
        this.isWrapBreak = isWrapBreak;
    }

    @Override
    public void write(int b) throws IOException {
        if (b < 0) {
            b += 256;
        }
        if (this.charCount % 3 == 0) {
            int lookup = b >> 2;
            this.carryOver = b & 3;
            this.out.write(chars[lookup]);
        } else if (this.charCount % 3 == 1) {
            int lookup = (this.carryOver << 4) + (b >> 4) & 0x3F;
            this.carryOver = b & 0xF;
            this.out.write(chars[lookup]);
        } else if (this.charCount % 3 == 2) {
            int lookup = (this.carryOver << 2) + (b >> 6) & 0x3F;
            this.out.write(chars[lookup]);
            lookup = b & 0x3F;
            this.out.write(chars[lookup]);
            this.carryOver = 0;
        }
        ++this.charCount;
        if (this.isWrapBreak && this.charCount % 57 == 0) {
            this.out.write(10);
        }
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            this.write(buf[off + i]);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.charCount % 3 == 1) {
            int lookup = this.carryOver << 4 & 0x3F;
            this.out.write(chars[lookup]);
            this.out.write(61);
            this.out.write(61);
        } else if (this.charCount % 3 == 2) {
            int lookup = this.carryOver << 2 & 0x3F;
            this.out.write(chars[lookup]);
            this.out.write(61);
        }
        super.close();
    }

    public static String encode(byte[] bytes) {
        return Base64Encoder.encode(bytes, true);
    }

    public static String encode(byte[] bytes, boolean isWrapBreak) {
        ByteArrayOutputStream out = new ByteArrayOutputStream((int)((double)bytes.length * 1.4));
        Base64Encoder encodedOut = new Base64Encoder(out, isWrapBreak);
        try {
            encodedOut.write(bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                encodedOut.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return out.toString();
    }
}

