/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.encrypt;

import android.os.Build;
import android.util.Base64;
import com.bfcy.base.encrypt.CryptoProvider;
import com.bfcy.base.encrypt.InsecureSHA1PRNGKeyDerivator;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class DesUtil {
    private static final String IVPARAMETERSPEC = "01020304";
    private static final String ALGORITHM = "DES";
    private static final String CIPHER_ALGORITHM = "DES/CBC/PKCS5Padding";
    private static final String CHARSET = "utf-8";
    private static final String HEX = "0123456789ABCDEF";
    private static final String SHA1PRNG = "SHA1PRNG";

    public static void main(String[] args) {
        String string = "123456";
        String strEncode = DesUtil.encrypt("1234567890", string);
        String strDecode = DesUtil.decrypt("1234567890", strEncode);
        System.out.println("\u5f85\u52a0\u5bc6\u6570\u636e: " + string);
        System.out.println("\u52a0\u5bc6\u540e\u6570\u636e: " + strEncode);
        System.out.println("\u89e3\u5bc6\u540e\u6570\u636e: " + strDecode);
    }

    public static String encrypt(String key, String data) {
        if (key == null || key.length() < 8) {
            throw new RuntimeException("\u52a0\u5bc6\u5931\u8d25\uff0ckey\u4e0d\u80fd\u5c0f\u4e8e8\u4f4d");
        }
        if (data == null || data.length() == 0) {
            return null;
        }
        try {
            Key secretKey = DesUtil.generateKey(key);
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            IvParameterSpec iv = new IvParameterSpec(IVPARAMETERSPEC.getBytes(CHARSET));
            cipher.init(1, secretKey, iv);
            byte[] bytes = cipher.doFinal(data.getBytes(CHARSET));
            return Base64.encodeToString((byte[])bytes, (int)0);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String decrypt(String key, String data) {
        if (key == null || key.length() < 8) {
            throw new RuntimeException("\u52a0\u5bc6\u5931\u8d25\uff0ckey\u4e0d\u80fd\u5c0f\u4e8e8\u4f4d");
        }
        if (data == null || data.length() == 0) {
            return null;
        }
        try {
            Key secretKey = DesUtil.generateKey(key);
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            IvParameterSpec iv = new IvParameterSpec(IVPARAMETERSPEC.getBytes(CHARSET));
            cipher.init(2, secretKey, iv);
            return new String(cipher.doFinal(Base64.decode((byte[])data.getBytes(), (int)0)), CHARSET);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Key generateKey(String key) throws Exception {
        DESKeySpec dks = new DESKeySpec(key.getBytes(CHARSET));
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(ALGORITHM);
        return keyFactory.generateSecret(dks);
    }

    private static Key generateKey2(String key) throws Exception {
        KeyGenerator kgen = KeyGenerator.getInstance(ALGORITHM);
        SecureRandom sr = null;
        if (Build.VERSION.SDK_INT >= 28) {
            byte[] passwordBytes = key.getBytes();
            return new SecretKeySpec(InsecureSHA1PRNGKeyDerivator.deriveInsecureKey(passwordBytes, 32), ALGORITHM);
        }
        sr = Build.VERSION.SDK_INT >= 24 ? SecureRandom.getInstance(SHA1PRNG, new CryptoProvider()) : (Build.VERSION.SDK_INT >= 17 ? SecureRandom.getInstance(SHA1PRNG, "Crypto") : SecureRandom.getInstance(SHA1PRNG));
        sr.setSeed(key.getBytes());
        kgen.init(64, sr);
        SecretKey skey = kgen.generateKey();
        byte[] raw = skey.getEncoded();
        return new SecretKeySpec(raw, ALGORITHM);
    }

    private String generateKey3() {
        try {
            SecureRandom localSecureRandom = SecureRandom.getInstance(SHA1PRNG);
            byte[] bytes_key = new byte[20];
            localSecureRandom.nextBytes(bytes_key);
            String str_key = this.toHex(bytes_key);
            return str_key;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String toHex(byte[] buf) {
        if (buf == null) {
            return "";
        }
        StringBuffer result = new StringBuffer(2 * buf.length);
        for (int i = 0; i < buf.length; ++i) {
            DesUtil.appendHex(result, buf[i]);
        }
        return result.toString();
    }

    private static void appendHex(StringBuffer sb, byte b) {
        sb.append(HEX.charAt(b >> 4 & 0xF)).append(HEX.charAt(b & 0xF));
    }
}

