/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.encrypt;

public class InsecureSHA1PRNGKeyDerivator {
    private static final int[] END_FLAGS = new int[]{Integer.MIN_VALUE, 0x800000, 32768, 128};
    private static final int[] RIGHT1 = new int[]{0, 40, 48, 56};
    private static final int[] RIGHT2 = new int[]{0, 8, 16, 24};
    private static final int[] LEFT = new int[]{0, 24, 16, 8};
    private static final int[] MASK = new int[]{-1, 0xFFFFFF, 65535, 255};
    private static final int HASHBYTES_TO_USE = 20;
    private static final int FRAME_LENGTH = 16;
    private static final int COUNTER_BASE = 0;
    private static final int HASHCOPY_OFFSET = 0;
    private static final int EXTRAFRAME_OFFSET = 5;
    private static final int FRAME_OFFSET = 21;
    private static final int MAX_BYTES = 48;
    private static final int UNDEFINED = 0;
    private static final int SET_SEED = 1;
    private static final int NEXT_BYTES = 2;
    private static final int H0 = 1732584193;
    private static final int H1 = -271733879;
    private static final int H2 = -1732584194;
    private static final int H3 = 271733878;
    private static final int H4 = -1009589776;
    private static final int BYTES_OFFSET = 81;
    private static final int HASH_OFFSET = 82;
    private static final int DIGEST_LENGTH = 20;
    private transient int[] seed = new int[87];
    private transient long seedLength;
    private transient int[] copies;
    private transient byte[] nextBytes;
    private transient int nextBIndex;
    private transient long counter;
    private transient int state;

    private InsecureSHA1PRNGKeyDerivator() {
        this.seed[82] = 1732584193;
        this.seed[83] = -271733879;
        this.seed[84] = -1732584194;
        this.seed[85] = 271733878;
        this.seed[86] = -1009589776;
        this.seedLength = 0L;
        this.copies = new int[37];
        this.nextBytes = new byte[20];
        this.nextBIndex = 20;
        this.counter = 0L;
        this.state = 0;
    }

    public static byte[] deriveInsecureKey(byte[] seed, int keySizeInBytes) {
        InsecureSHA1PRNGKeyDerivator derivator = new InsecureSHA1PRNGKeyDerivator();
        derivator.setSeed(seed);
        byte[] key = new byte[keySizeInBytes];
        derivator.nextBytes(key);
        return key;
    }

    private static void computeHash(int[] arrW) {
        int temp;
        int t;
        int a = arrW[82];
        int b = arrW[83];
        int c = arrW[84];
        int d = arrW[85];
        int e = arrW[86];
        for (t = 16; t < 80; ++t) {
            temp = arrW[t - 3] ^ arrW[t - 8] ^ arrW[t - 14] ^ arrW[t - 16];
            arrW[t] = temp << 1 | temp >>> 31;
        }
        for (t = 0; t < 20; ++t) {
            temp = (a << 5 | a >>> 27) + (b & c | ~b & d) + (e + arrW[t] + 1518500249);
            e = d;
            d = c;
            c = b << 30 | b >>> 2;
            b = a;
            a = temp;
        }
        for (t = 20; t < 40; ++t) {
            temp = (a << 5 | a >>> 27) + (b ^ c ^ d) + (e + arrW[t] + 1859775393);
            e = d;
            d = c;
            c = b << 30 | b >>> 2;
            b = a;
            a = temp;
        }
        for (t = 40; t < 60; ++t) {
            temp = (a << 5 | a >>> 27) + (b & c | b & d | c & d) + (e + arrW[t] + -1894007588);
            e = d;
            d = c;
            c = b << 30 | b >>> 2;
            b = a;
            a = temp;
        }
        for (t = 60; t < 80; ++t) {
            temp = (a << 5 | a >>> 27) + (b ^ c ^ d) + (e + arrW[t] + -899497514);
            e = d;
            d = c;
            c = b << 30 | b >>> 2;
            b = a;
            a = temp;
        }
        arrW[82] = arrW[82] + a;
        arrW[83] = arrW[83] + b;
        arrW[84] = arrW[84] + c;
        arrW[85] = arrW[85] + d;
        arrW[86] = arrW[86] + e;
    }

    private static void updateHash(int[] intArray, byte[] byteInput, int fromByte, int toByte) {
        int byteIndex;
        int index = intArray[81];
        int i = fromByte;
        int wordIndex = index >> 2;
        intArray[81] = index + toByte - fromByte + 1 & 0x3F;
        if (byteIndex != 0) {
            for (byteIndex = index & 3; i <= toByte && byteIndex < 4; ++byteIndex, ++i) {
                int n = wordIndex;
                intArray[n] = intArray[n] | (byteInput[i] & 0xFF) << (3 - byteIndex << 3);
            }
            if (byteIndex == 4 && ++wordIndex == 16) {
                InsecureSHA1PRNGKeyDerivator.computeHash(intArray);
                wordIndex = 0;
            }
            if (i > toByte) {
                return;
            }
        }
        int maxWord = toByte - i + 1 >> 2;
        for (int k = 0; k < maxWord; ++k) {
            intArray[wordIndex] = (byteInput[i] & 0xFF) << 24 | (byteInput[i + 1] & 0xFF) << 16 | (byteInput[i + 2] & 0xFF) << 8 | byteInput[i + 3] & 0xFF;
            i += 4;
            if (++wordIndex < 16) continue;
            InsecureSHA1PRNGKeyDerivator.computeHash(intArray);
            wordIndex = 0;
        }
        int nBytes = toByte - i + 1;
        if (nBytes != 0) {
            int w = (byteInput[i] & 0xFF) << 24;
            if (nBytes != 1) {
                w |= (byteInput[i + 1] & 0xFF) << 16;
                if (nBytes != 2) {
                    w |= (byteInput[i + 2] & 0xFF) << 8;
                }
            }
            intArray[wordIndex] = w;
        }
    }

    private void updateSeed(byte[] bytes) {
        InsecureSHA1PRNGKeyDerivator.updateHash(this.seed, bytes, 0, bytes.length - 1);
        this.seedLength += (long)bytes.length;
    }

    private void setSeed(byte[] seed) {
        if (seed == null) {
            throw new NullPointerException("seed == null");
        }
        if (this.state == 2) {
            System.arraycopy(this.copies, 0, this.seed, 82, 5);
        }
        this.state = 1;
        if (seed.length != 0) {
            this.updateSeed(seed);
        }
    }

    protected synchronized void nextBytes(byte[] bytes) {
        int n;
        int i;
        int lastWord;
        int extrabytes = 7;
        if (bytes == null) {
            throw new NullPointerException("bytes == null");
        }
        int n2 = lastWord = this.seed[81] == 0 ? 0 : this.seed[81] + 7 >> 2;
        if (this.state == 0) {
            throw new IllegalStateException("No seed supplied!");
        }
        if (this.state == 1) {
            System.arraycopy(this.seed, 82, this.copies, 0, 5);
            for (i = lastWord + 3; i < 18; ++i) {
                this.seed[i] = 0;
            }
            long bits = (this.seedLength << 3) + 64L;
            if (this.seed[81] < 48) {
                this.seed[14] = (int)(bits >>> 32);
                this.seed[15] = (int)(bits & 0xFFFFFFFFFFFFFFFFL);
            } else {
                this.copies[19] = (int)(bits >>> 32);
                this.copies[20] = (int)(bits & 0xFFFFFFFFFFFFFFFFL);
            }
            this.nextBIndex = 20;
        }
        this.state = 2;
        if (bytes.length == 0) {
            return;
        }
        int nextByteToReturn = 0;
        int n3 = n = 20 - this.nextBIndex < bytes.length - nextByteToReturn ? 20 - this.nextBIndex : bytes.length - nextByteToReturn;
        if (n > 0) {
            System.arraycopy(this.nextBytes, this.nextBIndex, bytes, nextByteToReturn, n);
            this.nextBIndex += n;
            nextByteToReturn += n;
        }
        if (nextByteToReturn >= bytes.length) {
            return;
        }
        n = this.seed[81] & 3;
        do {
            if (n == 0) {
                this.seed[lastWord] = (int)(this.counter >>> 32);
                this.seed[lastWord + 1] = (int)(this.counter & 0xFFFFFFFFFFFFFFFFL);
                this.seed[lastWord + 2] = END_FLAGS[0];
            } else {
                int n4 = lastWord;
                this.seed[n4] = this.seed[n4] | (int)(this.counter >>> RIGHT1[n] & (long)MASK[n]);
                this.seed[lastWord + 1] = (int)(this.counter >>> RIGHT2[n] & 0xFFFFFFFFFFFFFFFFL);
                this.seed[lastWord + 2] = (int)(this.counter << LEFT[n] | (long)END_FLAGS[n]);
            }
            if (this.seed[81] > 48) {
                this.copies[5] = this.seed[16];
                this.copies[6] = this.seed[17];
            }
            InsecureSHA1PRNGKeyDerivator.computeHash(this.seed);
            if (this.seed[81] > 48) {
                System.arraycopy(this.seed, 0, this.copies, 21, 16);
                System.arraycopy(this.copies, 5, this.seed, 0, 16);
                InsecureSHA1PRNGKeyDerivator.computeHash(this.seed);
                System.arraycopy(this.copies, 21, this.seed, 0, 16);
            }
            ++this.counter;
            int j = 0;
            for (i = 0; i < 5; ++i) {
                int k = this.seed[82 + i];
                this.nextBytes[j] = (byte)(k >>> 24);
                this.nextBytes[j + 1] = (byte)(k >>> 16);
                this.nextBytes[j + 2] = (byte)(k >>> 8);
                this.nextBytes[j + 3] = (byte)k;
                j += 4;
            }
            this.nextBIndex = 0;
            int n5 = j = 20 < bytes.length - nextByteToReturn ? 20 : bytes.length - nextByteToReturn;
            if (j <= 0) continue;
            System.arraycopy(this.nextBytes, 0, bytes, nextByteToReturn, j);
            nextByteToReturn += j;
            this.nextBIndex += j;
        } while (nextByteToReturn < bytes.length);
    }
}

