/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.http;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Log;
import com.bfcy.base.BaseApp;
import com.bfcy.base.http.SerializableOkHttpCookies;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import okhttp3.Cookie;
import okhttp3.HttpUrl;

public class PersistentCookieStore {
    private static final String LOG_TAG = "PersistentCookieStore";
    private static final String COOKIE_PREFS = "Cookies_Prefs";
    private final Map<String, Map<String, Cookie>> cookies;
    private final SharedPreferences cookiePrefs;
    private static PersistentCookieStore mInstance;

    public static PersistentCookieStore getInstance() {
        if (mInstance == null) {
            mInstance = new PersistentCookieStore(BaseApp.getInstance().getApplicationContext());
        }
        return mInstance;
    }

    private PersistentCookieStore(Context context) {
        this.cookiePrefs = context.getSharedPreferences(COOKIE_PREFS, 0);
        this.cookies = new HashMap<String, Map<String, Cookie>>();
        Map prefsMap = this.cookiePrefs.getAll();
        for (Map.Entry entry : prefsMap.entrySet()) {
            String[] cookieNames;
            for (String name : cookieNames = TextUtils.split((String)((String)entry.getValue()), (String)",")) {
                Cookie decodedCookie;
                String encodedCookie = this.cookiePrefs.getString(name, null);
                if (encodedCookie == null || (decodedCookie = this.decodeCookie(encodedCookie)) == null) continue;
                if (!this.cookies.containsKey(entry.getKey())) {
                    this.cookies.put((String)entry.getKey(), new ConcurrentHashMap());
                }
                this.cookies.get(entry.getKey()).put(name, decodedCookie);
            }
        }
    }

    protected String getCookieToken(Cookie cookie) {
        return cookie.name() + "@" + cookie.domain();
    }

    public synchronized void add(HttpUrl url, Cookie cookie) {
        String name = this.getCookieToken(cookie);
        if (!cookie.persistent() || cookie.expiresAt() > System.currentTimeMillis()) {
            if (!this.cookies.containsKey(url.host())) {
                this.cookies.put(url.host(), new ConcurrentHashMap());
            }
            this.cookies.get(url.host()).put(name, cookie);
        } else if (this.cookies.containsKey(url.host())) {
            this.cookies.get(url.host()).remove(name);
        }
        if (this.cookies.get(url.host()) != null) {
            SharedPreferences.Editor prefsWriter = this.cookiePrefs.edit();
            prefsWriter.putString(url.host(), TextUtils.join((CharSequence)",", this.cookies.get(url.host()).keySet()));
            prefsWriter.putString(name, this.encodeCookie(new SerializableOkHttpCookies(cookie)));
            prefsWriter.apply();
        }
    }

    public List<Cookie> get(HttpUrl url) {
        ArrayList<Cookie> ret = new ArrayList<Cookie>();
        if (this.cookies.containsKey(url.host())) {
            ret.addAll(this.cookies.get(url.host()).values());
        }
        return ret;
    }

    public synchronized boolean removeAll() {
        SharedPreferences.Editor prefsWriter = this.cookiePrefs.edit();
        prefsWriter.clear();
        prefsWriter.apply();
        this.cookies.clear();
        return true;
    }

    public synchronized boolean remove(HttpUrl url, Cookie cookie) {
        String name = this.getCookieToken(cookie);
        if (this.cookies.containsKey(url.host()) && this.cookies.get(url.host()).containsKey(name)) {
            this.cookies.get(url.host()).remove(name);
            SharedPreferences.Editor prefsWriter = this.cookiePrefs.edit();
            if (this.cookiePrefs.contains(name)) {
                prefsWriter.remove(name);
            }
            prefsWriter.putString(url.host(), TextUtils.join((CharSequence)",", this.cookies.get(url.host()).keySet()));
            prefsWriter.apply();
            return true;
        }
        return false;
    }

    public synchronized List<Cookie> getCookies() {
        ArrayList<Cookie> ret = new ArrayList<Cookie>();
        for (String key : this.cookies.keySet()) {
            ret.addAll(this.cookies.get(key).values());
        }
        return ret;
    }

    protected String encodeCookie(SerializableOkHttpCookies cookie) {
        if (cookie == null) {
            return null;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ObjectOutputStream outputStream = new ObjectOutputStream(os);
            outputStream.writeObject(cookie);
        }
        catch (IOException e) {
            Log.d((String)LOG_TAG, (String)"IOException in encodeCookie", (Throwable)e);
            return null;
        }
        return this.byteArrayToHexString(os.toByteArray());
    }

    protected Cookie decodeCookie(String cookieString) {
        byte[] bytes = this.hexStringToByteArray(cookieString);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        Cookie cookie = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            cookie = ((SerializableOkHttpCookies)objectInputStream.readObject()).getCookies();
        }
        catch (IOException e) {
            Log.d((String)LOG_TAG, (String)"IOException in decodeCookie", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            Log.d((String)LOG_TAG, (String)"ClassNotFoundException in decodeCookie", (Throwable)e);
        }
        return cookie;
    }

    protected String byteArrayToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte element : bytes) {
            int v = element & 0xFF;
            if (v < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(v));
        }
        return sb.toString().toUpperCase(Locale.US);
    }

    protected byte[] hexStringToByteArray(String hexString) {
        int len = hexString.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(hexString.charAt(i), 16) << 4) + Character.digit(hexString.charAt(i + 1), 16));
        }
        return data;
    }
}

