/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.log;

import android.util.Log;
import com.bfcy.base.BaseApp;
import com.bfcy.base.log.LoggerUtil;

public class Logger {
    public static boolean LOG_ENABLE = true;

    public static void v(String tag, String msg) {
        Logger.log(2, tag, null, msg);
    }

    public static void d(String tag, String msg) {
        Logger.log(3, tag, null, msg);
    }

    public static void i(String tag, String msg) {
        Logger.log(4, tag, null, msg);
    }

    public static void i(String tag, String prefix, String msg) {
        Logger.log(4, tag, prefix, msg);
    }

    public static void w(String tag, String msg) {
        Logger.log(5, tag, null, msg);
    }

    public static void e(String tag, String msg) {
        Logger.log(6, tag, null, msg);
    }

    private static void log(int level, String tag, String prefix, String msg) {
        if (msg == null) {
            msg = "null";
        }
        if (LOG_ENABLE && BaseApp.isDebug()) {
            int maxLength = 3000;
            while (msg.length() > maxLength) {
                String s = msg.substring(0, maxLength);
                if (prefix != null) {
                    s = prefix + s;
                }
                Logger.realLog(level, tag, s);
                msg = msg.substring(maxLength);
            }
            if (prefix != null) {
                msg = prefix + msg;
            }
            Logger.realLog(level, tag, msg);
        }
    }

    private static void realLog(int level, String tag, String msg) {
        Log.println((int)level, (String)tag, (String)msg);
        LoggerUtil.saveLog(tag, msg);
    }
}

