/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.log;

import android.os.Process;
import com.bfcy.base.BaseApp;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class LoggerUtil {
    private static File logFile;
    private static String LOG_PATH;
    private static SimpleDateFormat sdf;
    private static final String formatTime = "yyyy-MM-dd HH:mm:ss.SSS";
    private static long currentFileTime;
    private static LogCallback callback;

    private static String getFileName() {
        if (sdf == null) {
            sdf = new SimpleDateFormat("yyyyMMddHHmmss", Locale.CHINA);
        }
        return "log-" + sdf.format(new Date()) + ".txt";
    }

    private static boolean needNewFile() {
        if (currentFileTime == 0L || logFile == null || !logFile.exists()) {
            return true;
        }
        long time = System.currentTimeMillis();
        return time - currentFileTime > 0x6DDD00L;
    }

    public static void setLogCallback(LogCallback callback) {
        LoggerUtil.callback = callback;
    }

    public static void saveLog(String tag, String string) {
        if (LoggerUtil.needNewFile()) {
            File file = new File(LOG_PATH);
            if (!file.exists()) {
                file.mkdirs();
            }
            if (!(logFile = new File(file, LoggerUtil.getFileName())).exists()) {
                try {
                    currentFileTime = System.currentTimeMillis();
                    logFile.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            LoggerUtil.setAppendFile(tag, string);
        } else {
            LoggerUtil.setAppendFile(tag, string);
        }
    }

    private static void setAppendFile(String tag, String value) {
        if (logFile == null || !logFile.exists()) {
            return;
        }
        try (FileOutputStream fos = new FileOutputStream(logFile, true);){
            String prefix = new SimpleDateFormat(formatTime, Locale.CHINA).format(new Date()) + " : " + Process.myPid() + "-" + Process.myTid() + " : " + tag + " :";
            value = prefix + value + System.lineSeparator();
            byte[] bytes = callback != null ? callback.callback(value) : value.getBytes(StandardCharsets.UTF_8);
            fos.write(bytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        LOG_PATH = BaseApp.getContext().getExternalFilesDir("").getAbsolutePath() + File.separator + "AndroidLog/";
    }

    static interface LogCallback {
        public byte[] callback(String var1);
    }
}

