/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.media;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;

public class MediaUtil {
    private static final String TAG = "MediaUtil";

    public static String getRealFilePath(Context context, Uri uri) {
        Cursor cursor;
        if (null == uri) {
            return null;
        }
        String scheme = uri.getScheme();
        String data = null;
        if (scheme == null) {
            data = uri.getPath();
        } else if ("file".equals(scheme)) {
            data = uri.getPath();
        } else if ("content".equals(scheme) && null != (cursor = context.getContentResolver().query(uri, new String[]{"_data"}, null, null, null))) {
            int index;
            if (cursor.moveToFirst() && (index = cursor.getColumnIndex("_data")) > -1) {
                data = cursor.getString(index);
            }
            cursor.close();
        }
        return data;
    }

    public static String getFileName(String path) {
        String[] ss2;
        String[] ss1;
        String name = "";
        if (!TextUtils.isEmpty((CharSequence)path) && (ss1 = path.split("/")).length > 0 && (ss2 = ss1[ss1.length - 1].split("\\.")).length > 0) {
            name = ss2[0];
        }
        return name;
    }

    public static String getUriData(Uri data) {
        String scheme = data.getScheme();
        String host = data.getHost();
        int port = data.getPort();
        String path = data.getPath();
        String query = data.getQuery();
        String message = data.getQueryParameter("message");
        Log.e((String)TAG, (String)("scheme:" + scheme));
        Log.e((String)TAG, (String)("host:" + host));
        Log.e((String)TAG, (String)("port:" + port));
        Log.e((String)TAG, (String)("path:" + path));
        Log.e((String)TAG, (String)("query:" + query));
        return scheme + host + port + path + query + message;
    }
}

