/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.media;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.text.TextUtils;
import android.util.Log;
import android.widget.ImageView;
import android.widget.SeekBar;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.bfcy.base.BaseActivity;
import com.bfcy.base.R;
import com.bfcy.base.media.MediaUtil;
import com.bfcy.base.media.MusicService;
import com.bfcy.base.utils.TimeUtil;

public class MusicMediaPlayerActivity
extends BaseActivity {
    private Uri uri;
    private String audioPath;
    private String audioName;
    private TextView tvAudioName;
    private ImageView btnPrevious;
    private ImageView btnPlay;
    private ImageView btnNext;
    private TextView tvCurrentTime;
    private SeekBar seekBar;
    private TextView tvDurationTime;
    private MusicService.MusicBinder musicBinder;
    private final ServiceConnection musicServiceConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, IBinder service) {
            MusicMediaPlayerActivity.this.musicBinder = (MusicService.MusicBinder)service;
            if (MusicMediaPlayerActivity.this.uri != null) {
                MusicMediaPlayerActivity.this.musicBinder.setMediaPlayerListener(MusicMediaPlayerActivity.this.playerListener);
                MusicMediaPlayerActivity.this.musicBinder.playMusic(MusicMediaPlayerActivity.this.uri);
            } else if (!TextUtils.isEmpty((CharSequence)MusicMediaPlayerActivity.this.audioPath)) {
                MusicMediaPlayerActivity.this.musicBinder.setMediaPlayerListener(MusicMediaPlayerActivity.this.playerListener);
                MusicMediaPlayerActivity.this.musicBinder.playMusic(MusicMediaPlayerActivity.this.audioPath);
            }
        }

        public void onServiceDisconnected(ComponentName name) {
        }
    };
    private final MusicService.MediaPlayerListener playerListener = new MusicService.MediaPlayerListener(){

        @Override
        public void onStartPlay() {
            MusicMediaPlayerActivity.this.btnPlay.setImageResource(R.drawable.audio_btn_pause);
            MusicMediaPlayerActivity.this.seekBar.setProgress(0);
        }

        @Override
        public void onProgress(int currentPosition, int duration) {
            MusicMediaPlayerActivity.this.tvCurrentTime.setText((CharSequence)TimeUtil.formatMediaTime(currentPosition));
            MusicMediaPlayerActivity.this.tvDurationTime.setText((CharSequence)TimeUtil.formatMediaTime(duration));
            int progress = currentPosition * 100 / duration;
            MusicMediaPlayerActivity.this.seekBar.setProgress(progress);
        }

        @Override
        public void onCompletion() {
            MusicMediaPlayerActivity.this.btnPlay.setImageResource(R.drawable.audio_btn_play);
            MusicMediaPlayerActivity.this.seekBar.setProgress(100);
        }

        @Override
        public void onError() {
        }

        @Override
        public void onSeekComplete() {
        }
    };

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_music_media_player);
        this.initView();
    }

    private void initView() {
        this.initMediaData();
        this.initMusicService();
        this.findView();
        this.tvAudioName.setText((CharSequence)this.audioName);
    }

    private void findView() {
        this.tvAudioName = (TextView)this.findViewById(R.id.tvAudioName);
        this.btnPrevious = (ImageView)this.findViewById(R.id.btnPrevious);
        this.btnPlay = (ImageView)this.findViewById(R.id.btnPlay);
        this.btnNext = (ImageView)this.findViewById(R.id.btnNext);
        this.tvCurrentTime = (TextView)this.findViewById(R.id.tvCurrentTime);
        this.seekBar = (SeekBar)this.findViewById(R.id.seekBar);
        this.tvDurationTime = (TextView)this.findViewById(R.id.tvDurationTime);
    }

    private void initMediaData() {
        Bundle bundle;
        Intent intent = this.getIntent();
        Log.i((String)this.TAG, (String)("Intent--intent:" + intent));
        String action = intent.getAction();
        if ("android.intent.action.VIEW".equals(action)) {
            this.uri = intent.getData();
            if (this.uri != null) {
                String url = this.uri.getPath();
                Log.i((String)this.TAG, (String)("Intent--url:" + url));
                String realUrl = MediaUtil.getRealFilePath((Context)this, this.uri);
                Log.i((String)this.TAG, (String)("Intent--realUrl:" + realUrl));
                this.audioName = MediaUtil.getFileName(realUrl);
                Log.i((String)this.TAG, (String)("Intent--data:" + intent.getDataString()));
                Log.i((String)this.TAG, (String)("Intent--data:" + MediaUtil.getUriData(this.uri)));
            }
        }
        if ((bundle = intent.getExtras()) != null) {
            this.audioPath = bundle.getString("audioPath", "");
            this.audioName = MediaUtil.getFileName(this.audioPath);
        }
    }

    private void initMusicService() {
        Intent serviceIntent = new Intent((Context)this, MusicService.class);
        this.bindService(serviceIntent, this.musicServiceConnection, 1);
    }
}

