/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.media;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bfcy.base.R;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;

public class MusicService
extends Service {
    private final String TAG = ((Object)((Object)this)).getClass().getSimpleName();
    private final int MSG_SEND_PROGRESS = 100;
    public static final String RESOURCE_PATH = "resource_path";
    public static final String RESOURCE_RUI = "resource_uri";
    public static final String CONTROL_TYPE = "control_type";
    public static final int TYPE_PLAY_MUSIC = 1;
    public static final int TYPE_PLAY_MUSIC_RESTART = 2;
    public static final int TYPE_PLAY_MUSIC_SWITCH = 3;
    public static final int TYPE_PAUSE_MUSIC = 4;
    public static final int TYPE_STOP_MUSIC = 5;
    private MediaPlayer mediaPlayer;
    private boolean isPaused = false;
    private String currentPath = "";
    private Uri currentUri = Uri.parse((String)"");
    private boolean isLooping = false;
    private MediaPlayerListener playerListener;
    private Handler handler = new Handler(new Handler.Callback(){

        public boolean handleMessage(@NonNull Message msg) {
            if (msg.what == 100 && MusicService.this.playerListener != null) {
                MusicService.this.playerListener.onProgress(msg.arg1, msg.arg2);
            }
            return false;
        }
    });
    private Timer timer;
    private final TimerTask timerTask = new TimerTask(){

        @Override
        public void run() {
            if (MusicService.this.playerListener != null && MusicService.this.mediaPlayer != null && MusicService.this.mediaPlayer.isPlaying()) {
                MusicService.this.sendProgress();
            }
        }
    };

    private void sendProgress() {
        if (this.playerListener != null && this.mediaPlayer != null) {
            int currentPosition = this.mediaPlayer.getCurrentPosition();
            int duration = this.mediaPlayer.getDuration();
            Log.i((String)this.TAG, (String)("music--onProgress--currentPosition: " + currentPosition + "; duration: " + duration));
            Message message = Message.obtain();
            message.what = 100;
            message.arg1 = currentPosition;
            message.arg2 = duration;
            this.handler.sendMessage(message);
        }
    }

    private void initTimer() {
        if (this.timer == null) {
            this.timer = new Timer();
            this.timer.schedule(this.timerTask, 0L, 1000L);
        }
    }

    public void onCreate() {
        super.onCreate();
        Log.i((String)this.TAG, (String)"music--onCreate");
        this.initMediaPlayer();
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        Log.i((String)this.TAG, (String)"music--onBind");
        return new MusicBinder();
    }

    public boolean onUnbind(Intent intent) {
        Log.i((String)this.TAG, (String)"music--onUnbind");
        return super.onUnbind(intent);
    }

    public void onDestroy() {
        super.onDestroy();
        Log.i((String)this.TAG, (String)"music--onDestroy");
        this.release();
    }

    private void release() {
        if (this.mediaPlayer != null) {
            if (this.mediaPlayer.isPlaying()) {
                this.mediaPlayer.stop();
            }
            this.mediaPlayer.release();
            this.mediaPlayer = null;
        }
        if (this.playerListener != null) {
            this.playerListener = null;
        }
        if (this.timer != null) {
            this.timer.purge();
            this.timer.cancel();
            this.timer = null;
        }
        if (this.handler != null) {
            this.handler.removeCallbacksAndMessages(null);
            this.handler = null;
        }
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        Log.i((String)this.TAG, (String)"music--onStartCommand");
        if (intent != null) {
            int type = 0;
            String path = "";
            Uri uri = null;
            Bundle bundle = intent.getExtras();
            if (bundle != null) {
                type = bundle.getInt(CONTROL_TYPE, -1);
                path = bundle.getString(RESOURCE_PATH, "");
                uri = (Uri)bundle.getParcelable(RESOURCE_RUI);
                if (type > 0) {
                    if (!TextUtils.isEmpty((CharSequence)path)) {
                        this.dealControlType(type, path, null);
                    } else if (uri != null) {
                        this.dealControlType(type, null, uri);
                    }
                }
            }
            if (type <= 0) {
                type = intent.getIntExtra(CONTROL_TYPE, -1);
                if (TextUtils.isEmpty((CharSequence)path)) {
                    path = intent.getStringExtra(RESOURCE_PATH);
                }
                if (uri == null) {
                    uri = (Uri)intent.getParcelableExtra(RESOURCE_RUI);
                }
                if (type > 0) {
                    if (!TextUtils.isEmpty((CharSequence)path)) {
                        this.dealControlType(type, path, null);
                    } else if (uri != null) {
                        this.dealControlType(type, null, uri);
                    }
                }
            }
        }
        return 2;
    }

    private void dealControlType(int type, String path, Uri uri) {
        if (!TextUtils.isEmpty((CharSequence)path)) {
            switch (type) {
                case 1: 
                case 2: {
                    this.playMusicRestart(path);
                    break;
                }
                case 3: {
                    this.playMusicSwitch(path);
                    break;
                }
                case 4: {
                    this.pauseMusic();
                    break;
                }
                case 5: {
                    this.stopMusic();
                }
            }
        } else if (uri != null) {
            switch (type) {
                case 1: 
                case 2: {
                    this.playMusicRestart(uri);
                    break;
                }
                case 3: {
                    this.playMusicSwitch(uri);
                    break;
                }
                case 4: {
                    this.pauseMusic();
                    break;
                }
                case 5: {
                    this.stopMusic();
                }
            }
        }
    }

    private void initMediaPlayer() {
        if (this.mediaPlayer == null) {
            this.mediaPlayer = new MediaPlayer();
            this.mediaPlayer.setOnCompletionListener(mp -> {
                this.sendProgress();
                if (this.playerListener != null) {
                    this.playerListener.onCompletion();
                }
            });
            this.mediaPlayer.setOnPreparedListener(mp -> {
                if (this.mediaPlayer != null) {
                    this.mediaPlayer.start();
                    this.isPaused = false;
                    if (this.playerListener != null) {
                        this.playerListener.onStartPlay();
                    }
                }
            });
            this.mediaPlayer.setOnErrorListener((mp, what, extra) -> {
                if (this.playerListener != null) {
                    this.playerListener.onError();
                }
                return false;
            });
            this.mediaPlayer.setOnSeekCompleteListener(mp -> {
                if (this.playerListener != null) {
                    this.playerListener.onSeekComplete();
                }
            });
        }
    }

    private void playMusicDemo(int type) {
        if (type == 0) {
            this.mediaPlayer.reset();
            this.mediaPlayer = MediaPlayer.create((Context)this, (int)R.raw.bird_chirping);
            this.mediaPlayer.setLooping(this.isLooping);
            this.mediaPlayer.start();
        } else if (type == 1) {
            this.mediaPlayer.reset();
            this.mediaPlayer = MediaPlayer.create((Context)this, (int)R.raw.bird_chirping_running_water);
            this.mediaPlayer.setLooping(this.isLooping);
            this.mediaPlayer.start();
        } else if (type == 2) {
            this.mediaPlayer.reset();
            this.mediaPlayer = MediaPlayer.create((Context)this, (int)R.raw.dingdong);
            this.mediaPlayer.setLooping(true);
            this.mediaPlayer.start();
        }
    }

    private void playMusicRestart(String path) {
        Log.i((String)this.TAG, (String)"music--playMusicRestart--path");
        if (TextUtils.isEmpty((CharSequence)path)) {
            Log.i((String)this.TAG, (String)"music--playMusicRestart--path--Error: Resource Path is Empty");
            return;
        }
        this.initMediaPlayer();
        try {
            this.mediaPlayer.setAudioStreamType(3);
            this.mediaPlayer.reset();
            this.currentPath = path;
            this.mediaPlayer.setDataSource(path);
            this.mediaPlayer.setLooping(this.isLooping);
            this.mediaPlayer.prepareAsync();
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.i((String)this.TAG, (String)("music--playMusicRestart--path--Error: " + e.toString()));
        }
    }

    private void playMusicRestart(Uri uri) {
        Log.i((String)this.TAG, (String)"music--playMusicRestart--uri");
        if (uri == null) {
            Log.i((String)this.TAG, (String)"music--playMusicRestart--uri--Error: Resource Uri is null");
        }
        this.initMediaPlayer();
        try {
            this.mediaPlayer.setAudioStreamType(3);
            this.mediaPlayer.reset();
            this.currentUri = uri;
            this.mediaPlayer.setDataSource((Context)this, uri);
            this.mediaPlayer.setLooping(this.isLooping);
            this.mediaPlayer.prepareAsync();
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.i((String)this.TAG, (String)("music--playMusicRestart--uri--Error: " + e.toString()));
        }
    }

    private void prepare() {
        if (this.mediaPlayer != null) {
            try {
                this.mediaPlayer.prepare();
                this.mediaPlayer.start();
                this.isPaused = false;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void playMusicSwitch(String path) {
        Log.i((String)this.TAG, (String)"music--playMusicSwitch--path");
        this.initMediaPlayer();
        if (this.currentPath.equals(path)) {
            if (this.mediaPlayer.isPlaying()) {
                this.mediaPlayer.pause();
                this.isPaused = true;
            } else if (this.isPaused) {
                this.mediaPlayer.start();
                this.isPaused = false;
            } else {
                this.playMusicRestart(path);
            }
        } else {
            this.playMusicRestart(path);
        }
    }

    private void playMusicSwitch(Uri uri) {
        Log.i((String)this.TAG, (String)"music--playMusicSwitch--uri");
        this.initMediaPlayer();
        if (this.currentUri.equals((Object)uri)) {
            if (this.mediaPlayer.isPlaying()) {
                this.mediaPlayer.pause();
                this.isPaused = true;
            } else if (this.isPaused) {
                this.mediaPlayer.start();
                this.isPaused = false;
            } else {
                this.playMusicRestart(uri);
            }
        } else {
            this.playMusicRestart(uri);
        }
    }

    private void pauseMusic() {
        if (this.mediaPlayer != null && this.mediaPlayer.isPlaying()) {
            this.mediaPlayer.pause();
        }
    }

    private void stopMusic() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.stop();
        }
    }

    static interface MediaPlayerListener {
        public void onStartPlay();

        public void onProgress(int var1, int var2);

        public void onCompletion();

        public void onError();

        public void onSeekComplete();
    }

    public class MusicBinder
    extends Binder {
        MusicService getService() {
            return MusicService.this;
        }

        public void playMusic(String path) {
            this.playMusicRestart(path);
        }

        public void playMusic(Uri uri) {
            this.playMusicRestart(uri);
        }

        public void playMusicRestart(String path) {
            this.getService().playMusicRestart(path);
        }

        public void playMusicRestart(Uri uri) {
            this.getService().playMusicRestart(uri);
        }

        public void playMusicSwitch(String path) {
            this.getService().playMusicSwitch(path);
        }

        public void playMusicSwitch(Uri uri) {
            this.getService().playMusicSwitch(uri);
        }

        public void playMusicDemo(int type) {
            this.getService().playMusicDemo(type);
        }

        private void pauseMusic() {
            this.getService().pauseMusic();
        }

        private void stopMusic() {
            this.getService().stopMusic();
        }

        private void setLooping(boolean isLooping) {
            this.getService().isLooping = isLooping;
        }

        public void setMediaPlayerListener(MediaPlayerListener mediaPlayerListener) {
            MusicService.this.playerListener = mediaPlayerListener;
            if (mediaPlayerListener != null) {
                MusicService.this.initTimer();
            }
        }
    }
}

