/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.media;

import android.content.Context;
import android.content.Intent;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import com.bfcy.base.R;
import com.bfcy.base.utils.TimeUtil;
import java.io.IOException;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class VideoMediaPlayerActivity
extends AppCompatActivity
implements MediaPlayer.OnPreparedListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
SeekBar.OnSeekBarChangeListener {
    SurfaceView surfaceView;
    ImageView ivBack;
    SeekBar seekBar;
    RelativeLayout layoutController;
    ImageView vpPlayAndPause;
    ImageView screenOrientation;
    ImageView screenshot;
    TextView tvVideoName;
    ImageView videoPlaySetting;
    TextView videoCurrentTime;
    TextView videoDurationTime;
    private String videoName = "";
    private String videoPath = "";
    private Uri videoUri;
    private MediaPlayer mediaPlayer;
    private static final int MAX_PROGRESS = 10000;
    private boolean isPlaying = false;
    private Handler handler = new Handler(new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            switch (msg.what) {
                case 1000: {
                    if (VideoMediaPlayerActivity.this.layoutController.getVisibility() != 0) break;
                    VideoMediaPlayerActivity.this.layoutController.setVisibility(4);
                    break;
                }
                case 1001: {
                    if (!VideoMediaPlayerActivity.this.mediaPlayer.isPlaying() || VideoMediaPlayerActivity.this.layoutController.getVisibility() != 0) break;
                    VideoMediaPlayerActivity.this.updateProgress();
                    VideoMediaPlayerActivity.this.videoDurationTime.setText((CharSequence)TimeUtil.formatMediaTime(VideoMediaPlayerActivity.this.mediaPlayer.getDuration()));
                    VideoMediaPlayerActivity.this.videoCurrentTime.setText((CharSequence)TimeUtil.formatMediaTime(VideoMediaPlayerActivity.this.mediaPlayer.getCurrentPosition()));
                }
            }
            return false;
        }
    });
    private ScheduledExecutorService scheduledExecutorService;
    private TimerTask vpControllerTask = new TimerTask(){

        @Override
        public void run() {
            VideoMediaPlayerActivity.this.handler.sendEmptyMessage(1000);
        }
    };
    private TimerTask progressTask = new TimerTask(){

        @Override
        public void run() {
            VideoMediaPlayerActivity.this.handler.sendEmptyMessage(1001);
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_media_player_video);
        this.initData();
        this.findView();
        this.initViw();
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.handler != null) {
            this.handler.removeCallbacksAndMessages(null);
            this.handler = null;
        }
        if (this.mediaPlayer != null) {
            this.mediaPlayer.stop();
            this.mediaPlayer.release();
            this.mediaPlayer = null;
        }
    }

    private void initData() {
        String path;
        Intent intent = this.getIntent();
        this.videoPath = path = "android.resource://" + this.getPackageName() + "/" + R.raw.big_buck_bunny;
        Uri uri = Uri.parse((String)path);
        uri.getPath();
        uri.getUserInfo();
        uri.getAuthority();
        Log.i((String)"tag", (String)("---" + uri.getScheme() + "---" + uri.getQueryParameterNames() + "---" + uri.getUserInfo() + "---" + uri.getAuthority()));
        if (!TextUtils.isEmpty((CharSequence)path)) {
            String[] ss = path.split("/");
            this.videoName = ss[ss.length - 1];
        }
    }

    private void findView() {
        this.surfaceView = (SurfaceView)this.findViewById(R.id.surfaceView);
        this.ivBack = (ImageView)this.findViewById(R.id.ivBack);
        this.seekBar = (SeekBar)this.findViewById(R.id.seekBar);
        this.layoutController = (RelativeLayout)this.findViewById(R.id.layoutController);
        this.vpPlayAndPause = (ImageView)this.findViewById(R.id.vp_playAndPause);
        this.screenOrientation = (ImageView)this.findViewById(R.id.screenOrientation);
        this.screenshot = (ImageView)this.findViewById(R.id.screenshots);
        this.tvVideoName = (TextView)this.findViewById(R.id.video_name);
        this.videoPlaySetting = (ImageView)this.findViewById(R.id.video_play_setting);
        this.videoCurrentTime = (TextView)this.findViewById(R.id.video_current_time);
        this.videoDurationTime = (TextView)this.findViewById(R.id.video_duration_time);
        this.surfaceView.setOnClickListener(v -> {
            if (this.layoutController.getVisibility() == 0) {
                this.scheduledExecutorService.shutdownNow();
                this.layoutController.setVisibility(4);
            } else {
                this.startTimerTask();
                this.layoutController.setVisibility(0);
            }
        });
        this.ivBack.setOnClickListener(v -> this.finish());
        this.vpPlayAndPause.setOnClickListener(v -> {
            if (this.mediaPlayer.isPlaying()) {
                this.pauseVideo();
            } else {
                this.playVideo();
            }
        });
        this.screenOrientation.setOnClickListener(v -> {});
        this.screenshot.setOnClickListener(v -> {});
    }

    private void initViw() {
        this.tvVideoName.setText((CharSequence)this.videoName);
        this.seekBar.setMax(10000);
        this.seekBar.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
        this.initMediaPlayer();
        final GestureDetector gestureDetector = new GestureDetector((Context)this, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onDoubleTap(MotionEvent e) {
                if (VideoMediaPlayerActivity.this.mediaPlayer.isPlaying()) {
                    VideoMediaPlayerActivity.this.pauseVideo();
                } else {
                    VideoMediaPlayerActivity.this.playVideo();
                }
                return true;
            }

            public boolean onDoubleTapEvent(MotionEvent e) {
                return super.onDoubleTapEvent(e);
            }

            public boolean onSingleTapConfirmed(MotionEvent e) {
                return super.onSingleTapConfirmed(e);
            }
        });
        this.surfaceView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                return gestureDetector.onTouchEvent(event);
            }
        });
    }

    private void initMediaPlayer() {
        SurfaceHolder holder = this.surfaceView.getHolder();
        holder.addCallback((SurfaceHolder.Callback)new MyCallback());
        this.mediaPlayer = new MediaPlayer();
        this.mediaPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
        this.mediaPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
        this.mediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)this);
        try {
            this.mediaPlayer.setDataSource((Context)this, Uri.parse((String)this.videoPath));
            this.mediaPlayer.prepareAsync();
        }
        catch (IOException e) {
            e.printStackTrace();
            Toast.makeText((Context)this, (CharSequence)"\u64ad\u653e\u5f02\u5e38", (int)0).show();
        }
    }

    public void onPrepared(MediaPlayer mp) {
        this.playVideo();
        this.startTimerTask();
    }

    public void onCompletion(MediaPlayer mp) {
    }

    public boolean onError(MediaPlayer mp, int what, int extra) {
        return false;
    }

    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
        long seekBarProgress = seekBar.getProgress();
        long audioDuration = this.mediaPlayer.getDuration();
        int position = (int)(seekBarProgress * audioDuration / 10000L);
        this.mediaPlayer.seekTo(position);
    }

    private void startTimerTask() {
        this.scheduledExecutorService = Executors.newScheduledThreadPool(2);
        this.scheduledExecutorService.schedule(this.vpControllerTask, 6000L, TimeUnit.MILLISECONDS);
        this.scheduledExecutorService.scheduleWithFixedDelay(this.progressTask, 0L, 1000L, TimeUnit.MILLISECONDS);
    }

    private void updateProgress() {
        long position = this.mediaPlayer.getCurrentPosition();
        long duration = this.mediaPlayer.getDuration();
        Log.i((String)"tag", (String)("---" + position + "-" + duration));
        this.seekBar.setProgress((int)(position * 10000L / duration));
    }

    private void playVideo() {
        this.mediaPlayer.start();
        this.vpPlayAndPause.setImageResource(R.drawable.vp_btn_play);
    }

    private void pauseVideo() {
        this.mediaPlayer.pause();
        this.vpPlayAndPause.setImageResource(R.drawable.vp_btn_play_pause);
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        if (hasFocus && Build.VERSION.SDK_INT >= 19) {
            View decorView = this.getWindow().getDecorView();
            decorView.setSystemUiVisibility(5894);
        }
    }

    private class MyCallback
    implements SurfaceHolder.Callback {
        private MyCallback() {
        }

        public void surfaceCreated(SurfaceHolder holder) {
            VideoMediaPlayerActivity.this.mediaPlayer.setDisplay(holder);
        }

        public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
        }
    }
}

