/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.mqtt;

import android.util.Log;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.eclipse.paho.client.mqttv3.MqttTopic;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;

public class MqttManager {
    private String TAG = this.getClass().getSimpleName();
    public String host = "tcp://172.16.4.39:12345";
    private String username = "admin";
    private String password = "password";
    public static final String TOPIC_DEV = "dev/02/out";
    public static final String TOPIC_PHONE = "dev/01/in";
    private MqttClient client;
    private MqttConnectOptions options;
    private MqttCallback mqttCallback;
    private String IP = "172.16.4.39";
    private String POINT = "9999";
    private String mqtt_id = "20080101";
    private static MqttManager mqttManager;

    public MqttManager() {
        Log.i((String)this.TAG, (String)"---start");
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getMqtt_id() {
        return this.mqtt_id;
    }

    public void setMqtt_id(String mqtt_id) {
        this.mqtt_id = mqtt_id;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public MqttCallback getMqttCallback() {
        return this.mqttCallback;
    }

    public void setMqttCallback(MqttCallback mqttCallback) {
        this.mqttCallback = mqttCallback;
    }

    public static MqttManager getInstance() {
        if (mqttManager == null) {
            mqttManager = new MqttManager();
        }
        return mqttManager;
    }

    public void start() {
        System.out.println("MqttClientServer\u542f\u52a8----");
        Log.i((String)"tag", (String)"----start");
        try {
            this.client = new MqttClient(this.host, this.mqtt_id, (MqttClientPersistence)new MemoryPersistence());
            this.options = new MqttConnectOptions();
            this.options.setCleanSession(true);
            this.options.setUserName(this.username);
            this.options.setPassword(this.password.toCharArray());
            this.options.setConnectionTimeout(10);
            this.options.setKeepAliveInterval(20);
            this.client.setCallback(this.mqttCallback);
            MqttTopic topic = this.client.getTopic(TOPIC_PHONE);
            this.options.setWill(topic, "PhoneClose".getBytes(), 2, true);
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public void connect() {
        Log.i((String)this.TAG, (String)"---\u5f00\u59cb\u8fde\u63a5");
        if (this.client != null) {
            try {
                this.client.connect(this.options);
                Log.i((String)this.TAG, (String)("---connect" + this.client.isConnected()));
            }
            catch (MqttException e) {
                e.printStackTrace();
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
    }

    public void disconnect() {
        if (this.isConnected()) {
            try {
                this.client.disconnect();
            }
            catch (MqttException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isConnected() {
        return this.client != null && this.client.isConnected();
    }

    public void publishTopic() {
        this.publishTopic("\u9ed8\u8ba4\u6d88\u606f");
    }

    public MqttManager getMyMqttClient() {
        return this;
    }

    public MqttClient getMqttClient() {
        return this.client;
    }

    public void publishTopic(String str) {
        Log.i((String)this.TAG, (String)"---publish");
        Log.i((String)this.TAG, (String)("---publish" + this.client.isConnected()));
        try {
            MqttMessage message = new MqttMessage();
            message.setPayload(str.getBytes());
            this.client.publish(TOPIC_PHONE, message);
        }
        catch (MqttPersistenceException e) {
            e.printStackTrace();
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
    }

    public void publishTopic(String topic, String str) {
        Log.i((String)this.TAG, (String)"---publish");
        Log.i((String)this.TAG, (String)("---publish" + this.client.isConnected()));
        try {
            MqttMessage message = new MqttMessage();
            message.setPayload(str.getBytes());
            this.client.publish(topic, message);
        }
        catch (MqttPersistenceException e) {
            e.printStackTrace();
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
    }

    public void subscribeTopic() {
        String[] topic_allDev = new String[]{TOPIC_DEV};
        this.subscribeTopic(topic_allDev);
    }

    public void subscribeTopic(String[] topic) {
        try {
            int[] Qos = new int[]{1};
            this.client.subscribe(topic, Qos);
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
    }
}

