/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.mqtt;

import android.app.Service;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.util.Log;
import com.bfcy.base.mqtt.MqttManager;
import org.eclipse.paho.client.mqttv3.MqttCallback;

public class MqttService
extends Service {
    private String TAG = ((Object)((Object)this)).getClass().getSimpleName();
    private String username;
    private String password;
    private String host;
    private String mqttId;
    private MqttCallback mqttCallback;
    private MqttManager mqttManager;
    private MqttBinder mqttBinder = new MqttBinder();

    public MqttService() {
        Log.i((String)this.TAG, (String)"---start");
    }

    public IBinder onBind(Intent intent) {
        return this.mqttBinder;
    }

    public void onCreate() {
        super.onCreate();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        return super.onStartCommand(intent, flags, startId);
    }

    public void onDestroy() {
        super.onDestroy();
    }

    public class MqttBinder
    extends Binder {
        public MqttBinder setUsername(String username) {
            MqttService.this.username = username;
            return this;
        }

        public MqttBinder setPassword(String password) {
            MqttService.this.password = password;
            return this;
        }

        public MqttBinder setHost(String host) {
            MqttService.this.host = host;
            return this;
        }

        public MqttBinder setMqttId(String mqttId) {
            MqttService.this.mqttId = mqttId;
            return this;
        }

        public MqttBinder setCallback(MqttCallback mqttCallback) {
            MqttService.this.mqttCallback = mqttCallback;
            return this;
        }

        public void connect() {
            MqttService.this.mqttManager = MqttManager.getInstance();
            MqttService.this.mqttManager.setHost(MqttService.this.host);
            MqttService.this.mqttManager.setUsername(MqttService.this.username);
            MqttService.this.mqttManager.setPassword(MqttService.this.password);
            MqttService.this.mqttManager.setMqttCallback(MqttService.this.mqttCallback);
            MqttService.this.mqttManager.setMqtt_id(MqttService.this.mqttId);
            MqttService.this.mqttManager.start();
            MqttService.this.mqttManager.connect();
        }

        public void disConnect() {
            if (MqttService.this.mqttManager.isConnected()) {
                MqttService.this.mqttManager.disconnect();
            }
        }

        public void subscribeTopic(String[] topic) {
            if (MqttService.this.mqttManager.isConnected()) {
                MqttService.this.mqttManager.subscribeTopic(topic);
            }
        }

        public void publishTopic(String msg) {
            Log.i((String)MqttService.this.TAG, (String)"---publish");
            MqttService.this.mqttManager.publishTopic(msg);
        }

        public void publishTopic(String topic, String msg) {
            Log.i((String)MqttService.this.TAG, (String)"---publish");
            MqttService.this.mqttManager.publishTopic(topic, msg);
        }

        public MqttManager getMqttClient() {
            if (MqttService.this.mqttManager != null) {
                return MqttService.this.mqttManager.getMyMqttClient();
            }
            return null;
        }

        public boolean isConnected() {
            return MqttService.this.mqttManager != null && MqttService.this.mqttManager.isConnected();
        }
    }
}

