/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.tcp;

import android.app.Service;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.util.Log;
import com.bfcy.base.tcp.CommonTCPClientString;
import com.bfcy.base.tcp.callback.ICallback;

public class ClientService
extends Service {
    private String TAG = ((Object)((Object)this)).getClass().getSimpleName();
    private CommonTCPClientString client;
    private String IP;
    private int PORT;
    private ICallback callback;
    private MyBinder myBinder = new MyBinder();

    public void onCreate() {
        super.onCreate();
        Log.i((String)this.TAG, (String)"---serverStart");
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        return super.onStartCommand(intent, flags, startId);
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.client != null) {
            this.client.unConnect();
        }
    }

    public IBinder onBind(Intent intent) {
        return this.myBinder;
    }

    public class MyBinder
    extends Binder {
        public MyBinder() {
            Log.i((String)"tag", (String)"---startBinder");
        }

        public MyBinder setIP(String ip) {
            ClientService.this.IP = ip;
            return this;
        }

        public MyBinder setPort(int port) {
            ClientService.this.PORT = port;
            return this;
        }

        public MyBinder setCallback(ICallback callback) {
            ClientService.this.callback = callback;
            return this;
        }

        public void connect() {
            if (ClientService.this.client == null) {
                ClientService.this.client = new CommonTCPClientString();
                ClientService.this.client.setIP(ClientService.this.IP);
                ClientService.this.client.setPORT(ClientService.this.PORT);
                ClientService.this.client.setCallback(ClientService.this.callback);
                ClientService.this.client.connect();
            }
        }

        public void stopServer() {
            if (ClientService.this.client != null) {
                ClientService.this.client.unConnect();
            }
        }

        private boolean isConnected() {
            return false;
        }

        public void sendStringToServer(String msg) {
            ClientService.this.client.sendString(msg);
        }
    }
}

