/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.tcp;

import android.os.Message;
import android.util.Log;
import com.bfcy.base.tcp.CloseUtil;
import com.bfcy.base.tcp.callback.ICallback;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;

public class CommonTCPClientString {
    private String TAG = this.getClass().getSimpleName();
    private Socket socket;
    private ICallback callback;
    private boolean isRunning = true;
    private OutputStream outputStream;
    private InputStream inputStream;
    private String IP;
    private int PORT;
    private BufferedReader reader;
    private BufferedWriter writer;

    public ICallback getCallback() {
        return this.callback;
    }

    public void setCallback(ICallback callback) {
        this.callback = callback;
    }

    public String getIP() {
        return this.IP;
    }

    public void setIP(String IP) {
        this.IP = IP;
    }

    public int getPORT() {
        return this.PORT;
    }

    public void setPORT(int PORT) {
        this.PORT = PORT;
    }

    public CommonTCPClientString() {
        Log.i((String)this.TAG, (String)"---start");
    }

    public void connect() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    CommonTCPClientString.this.socket = new Socket(CommonTCPClientString.this.IP, CommonTCPClientString.this.PORT);
                    CommonTCPClientString.this.outputStream = new DataOutputStream(CommonTCPClientString.this.socket.getOutputStream());
                    CommonTCPClientString.this.inputStream = new DataInputStream(CommonTCPClientString.this.socket.getInputStream());
                    CommonTCPClientString.this.reader = new BufferedReader(new InputStreamReader(CommonTCPClientString.this.socket.getInputStream()));
                    CommonTCPClientString.this.writer = new BufferedWriter(new OutputStreamWriter(CommonTCPClientString.this.socket.getOutputStream()));
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            while (CommonTCPClientString.this.isRunning) {
                                CommonTCPClientString.this.handStringMessage();
                            }
                        }
                    }).start();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.out.println("\u5f02\u5e382");
                }
            }
        }).start();
    }

    public void unConnect() {
        CloseUtil.closeAll(this.outputStream, this.inputStream, this.socket);
    }

    private void handStringMessage() {
        try {
            String str = this.receiveString();
            Message message = Message.obtain();
            message.what = 2;
            message.obj = str;
            this.callback.getHandler().sendMessage(message);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String receiveString() throws IOException {
        return this.reader.readLine();
    }

    public void sendString(String msg) {
        try {
            this.writer.write(msg);
            this.writer.newLine();
            this.writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.close();
        }
    }

    private void close() {
        CloseUtil.closeAll(this.writer, this.reader, this.inputStream, this.outputStream, this.socket);
    }

    public boolean isConnect() {
        return this.socket != null && this.socket.isConnected();
    }
}

