/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.tcp;

import android.app.Service;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.util.Log;
import com.bfcy.base.tcp.TCPServerByteManager;
import com.bfcy.base.tcp.callback.ICallback;

public class ServerByteService
extends Service {
    private TCPServerByteManager server;
    private int PORT;
    private ICallback callback;
    private MyBinder myBinder = new MyBinder();

    public void onCreate() {
        super.onCreate();
        Log.i((String)"tag", (String)"---serverStart");
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        return super.onStartCommand(intent, flags, startId);
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.server != null) {
            this.server.stopServer();
        }
    }

    public IBinder onBind(Intent intent) {
        return this.myBinder;
    }

    public class MyBinder
    extends Binder {
        MyBinder() {
            Log.i((String)"tag", (String)"---startBinder");
        }

        public MyBinder setPort(int port) {
            ServerByteService.this.PORT = port;
            return this;
        }

        public MyBinder setCallback(ICallback callback) {
            ServerByteService.this.callback = callback;
            return this;
        }

        public void startServer() {
            if (ServerByteService.this.server == null) {
                ServerByteService.this.server = new TCPServerByteManager();
                ServerByteService.this.server.setPORT(ServerByteService.this.PORT);
                ServerByteService.this.server.setCallback(ServerByteService.this.callback);
                ServerByteService.this.server.startServer();
            }
        }

        public void stopServer() {
            if (ServerByteService.this.server != null) {
                ServerByteService.this.server.stopServer();
            }
        }

        public boolean isAnyClientConnected() {
            return ServerByteService.this.server.isAnyClientConnected();
        }

        public boolean isClientConnected(String clientName) {
            return ServerByteService.this.server.isClientConnected(clientName);
        }

        public boolean isClientConnectedByIP(String clientIP) {
            return ServerByteService.this.server.isClientConnectedByIP(clientIP);
        }

        public void sendStringToClientByName(String msg, String clientName) {
            ServerByteService.this.server.sendStringToClientByName(msg, clientName);
        }

        public void sendStringToClientByIP(String msg, String clientIP) {
            ServerByteService.this.server.sendStringToClientByIP(msg, clientIP);
        }

        public void sendByteToClientByName(byte[] bytes, String clientName) {
            ServerByteService.this.server.sendByteToClientByName(bytes, clientName);
        }

        public void sendByteToClientByIP(byte[] bytes, String clientIP) {
            ServerByteService.this.server.sendByteToClientByIP(bytes, clientIP);
        }

        public void sendStringToAllClient(String msg) {
            ServerByteService.this.server.sendStringToAllClient(msg);
        }

        public void sendByteToAllClient(byte[] bytes) {
            ServerByteService.this.server.sendByteToAllClient(bytes);
        }
    }
}

