/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.tcp;

import android.app.Service;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.util.Log;
import com.bfcy.base.tcp.TCPServerByteManager;
import com.bfcy.base.tcp.callback.ICallback;

public class ServerService
extends Service {
    private TCPServerByteManager server;
    private int PORT;
    private ICallback callback;
    private MyBinder myBinder = new MyBinder();

    public void onCreate() {
        super.onCreate();
        Log.i((String)"tag", (String)"---serverStart");
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        return super.onStartCommand(intent, flags, startId);
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.server != null) {
            this.server.stopServer();
        }
    }

    public IBinder onBind(Intent intent) {
        return this.myBinder;
    }

    public class MyBinder
    extends Binder {
        public MyBinder() {
            Log.i((String)"tag", (String)"---startBinder");
        }

        public MyBinder setPort(int port) {
            ServerService.this.PORT = port;
            return this;
        }

        public MyBinder setCallback(ICallback callback) {
            ServerService.this.callback = callback;
            return this;
        }

        public void startServer() {
            if (ServerService.this.server == null) {
                ServerService.this.server = new TCPServerByteManager();
                ServerService.this.server.setPORT(ServerService.this.PORT);
                ServerService.this.server.setCallback(ServerService.this.callback);
                ServerService.this.server.startServer();
            }
        }

        public void stopServer() {
            if (ServerService.this.server != null) {
                ServerService.this.server.stopServer();
            }
        }

        public boolean isAnyClientConnected() {
            return ServerService.this.server.isAnyClientConnected();
        }

        public boolean isClientConnected(String clientName) {
            return ServerService.this.server.isClientConnected(clientName);
        }

        public boolean isClientConnectedByIP(String clientIP) {
            return ServerService.this.server.isClientConnectedByIP(clientIP);
        }

        public void sendStringToClientByName(String msg, String clientName) {
            ServerService.this.server.sendStringToClientByName(msg, clientName);
        }

        public void sendStringToClientByIP(String msg, String clientIP) {
            ServerService.this.server.sendStringToClientByIP(msg, clientIP);
        }

        public void sendByteToClientByName(byte[] bytes, String clientName) {
            ServerService.this.server.sendByteToClientByName(bytes, clientName);
        }

        public void sendByteToClientByIP(byte[] bytes, String clientIP) {
            ServerService.this.server.sendByteToClientByIP(bytes, clientIP);
        }

        public void sendStringToAllClient(String msg) {
            ServerService.this.server.sendStringToAllClient(msg);
        }

        public void sendByteToAllClient(byte[] bytes) {
            ServerService.this.server.sendByteToAllClient(bytes);
        }
    }
}

