/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.tcp;

import android.app.Service;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.util.Log;
import com.bfcy.base.tcp.TCPServerByteManager;
import com.bfcy.base.tcp.callback.ICallback;

public class ServerStringService
extends Service {
    private TCPServerByteManager server;
    private int PORT;
    private ICallback callback;
    private MyBinder myBinder = new MyBinder();

    public void onCreate() {
        super.onCreate();
        Log.i((String)"tag", (String)"---serverStart");
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        return super.onStartCommand(intent, flags, startId);
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.server != null) {
            this.server.stopServer();
        }
    }

    public IBinder onBind(Intent intent) {
        return this.myBinder;
    }

    public class MyBinder
    extends Binder {
        public MyBinder() {
            Log.i((String)"tag", (String)"---startBinder");
        }

        public MyBinder setPort(int port) {
            ServerStringService.this.PORT = port;
            return this;
        }

        public MyBinder setCallback(ICallback callback) {
            ServerStringService.this.callback = callback;
            return this;
        }

        public void startServer() {
            if (ServerStringService.this.server == null) {
                ServerStringService.this.server = new TCPServerByteManager();
                ServerStringService.this.server.setPORT(ServerStringService.this.PORT);
                ServerStringService.this.server.setCallback(ServerStringService.this.callback);
                ServerStringService.this.server.startServer();
            }
        }

        public void stopServer() {
            if (ServerStringService.this.server != null) {
                ServerStringService.this.server.stopServer();
            }
        }

        public boolean isAnyClientConnected() {
            return ServerStringService.this.server.isAnyClientConnected();
        }

        public boolean isClientConnected(String clientName) {
            return ServerStringService.this.server.isClientConnected(clientName);
        }

        public boolean isClientConnectedByIP(String clientIP) {
            return ServerStringService.this.server.isClientConnectedByIP(clientIP);
        }

        public void sendStringToClientByName(String msg, String clientName) {
            ServerStringService.this.server.sendStringToClientByName(msg, clientName);
        }

        public void sendStringToClientByIP(String msg, String clientIP) {
            ServerStringService.this.server.sendStringToClientByIP(msg, clientIP);
        }

        public void sendByteToClientByName(byte[] bytes, String clientName) {
            ServerStringService.this.server.sendByteToClientByName(bytes, clientName);
        }

        public void sendByteToClientByIP(byte[] bytes, String clientIP) {
            ServerStringService.this.server.sendByteToClientByIP(bytes, clientIP);
        }

        public void sendStringToAllClient(String msg) {
            ServerStringService.this.server.sendStringToAllClient(msg);
        }

        public void sendByteToAllClient(byte[] bytes) {
            ServerStringService.this.server.sendByteToAllClient(bytes);
        }
    }
}

