/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.tcp;

import android.os.Message;
import android.util.Log;
import com.bfcy.base.tcp.CloseUtil;
import com.bfcy.base.tcp.callback.ICallback;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;

public class TCPServerStringManager {
    private String TAG = this.getClass().getSimpleName();
    private ServerSocket serverSocket;
    private int PORT;
    private boolean isStarted = false;
    private boolean isServerRunning = true;
    private ICallback callback;
    private Map<String, ConnectedClient> clients = new HashMap<String, ConnectedClient>();

    public int getPORT() {
        return this.PORT;
    }

    public void setPORT(int PORT) {
        this.PORT = PORT;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public void setStarted(boolean started) {
        this.isStarted = started;
    }

    public Map<String, ConnectedClient> getClients() {
        return this.clients;
    }

    public void setClients(Map<String, ConnectedClient> clients) {
        this.clients = clients;
    }

    public boolean isAnyClientConnected() {
        return !this.clients.isEmpty();
    }

    public boolean isClientConnected(String clientName) {
        if (!this.isAnyClientConnected()) {
            return false;
        }
        for (ConnectedClient client : this.clients.values()) {
            if (!client.getClientName().equals(clientName)) continue;
            Log.i((String)"tag", (String)"---\u5ba2\u6237\u7aef\u5b58\u5728");
            return true;
        }
        return false;
    }

    public boolean isClientConnectedByIP(String clientIP) {
        if (!this.isAnyClientConnected()) {
            return false;
        }
        for (String ip : this.clients.keySet()) {
            if (!ip.equals(clientIP)) continue;
            Log.i((String)"tag", (String)"---\u5ba2\u6237\u7aef\u5b58\u5728");
            return true;
        }
        return false;
    }

    public void sendStringToClientByName(String msg, String clientName) {
        this.sendByteToClientByName(msg.getBytes(), clientName);
    }

    public void sendStringToClientByIP(String msg, String clientIP) {
        this.sendByteToClientByIP(msg.getBytes(), clientIP);
    }

    public void sendStringToAllClient(String msg) {
        this.sendByteToAllClient(msg.getBytes());
    }

    public void sendByteToClientByName(byte[] bytes, String clientName) {
        for (ConnectedClient client : this.clients.values()) {
            if (!client.getClientName().equals(clientName)) continue;
            client.sendMessageToClient(bytes);
        }
    }

    public void sendByteToClientByIP(byte[] bytes, String clientIP) {
        this.clients.get(clientIP).sendMessageToClient(bytes);
    }

    public void sendByteToAllClient(byte[] bytes) {
        for (ConnectedClient client : this.clients.values()) {
            client.sendMessageToClient(bytes);
        }
    }

    public void setCallback(ICallback callback) {
        this.callback = callback;
    }

    public void startServer() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TCPServerStringManager.this.serverSocket = new ServerSocket(TCPServerStringManager.this.PORT);
                    Log.i((String)"tag", (String)"---ServerSocket");
                    while (TCPServerStringManager.this.isServerRunning) {
                        Socket socket = TCPServerStringManager.this.serverSocket.accept();
                        Log.i((String)"tag", (String)"---accept");
                        ConnectedClient client = new ConnectedClient(socket);
                        new Thread(client).start();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    public void stopServer() {
        this.isServerRunning = false;
        for (ConnectedClient client : this.clients.values()) {
            Socket socket = client.getSocket();
            if (socket == null) continue;
            try {
                socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            if (!this.serverSocket.isClosed()) {
                this.serverSocket.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private class ConnectedClient
    implements Runnable {
        private boolean isClientRunning = true;
        private String clientName;
        private String clientIP;
        private int clientPort;
        private byte[] byteMessageToClient = null;
        private String StringMessageToClient = "";
        private Socket socket;
        private BufferedReader reader;
        private BufferedWriter writer;
        private OutputStream outputStream;
        private InputStream inputStream;
        private ByteArrayOutputStream bos;

        public Socket getSocket() {
            return this.socket;
        }

        public String getClientName() {
            return this.clientName;
        }

        public String getClientIP() {
            return this.clientIP;
        }

        public int getPort() {
            return this.clientPort;
        }

        public ConnectedClient(Socket socket) {
            try {
                this.socket = socket;
                InetSocketAddress inetSocketAddress = (InetSocketAddress)socket.getRemoteSocketAddress();
                this.clientIP = inetSocketAddress.getAddress().getHostAddress();
                this.clientPort = inetSocketAddress.getPort();
                TCPServerStringManager.this.clients.put(this.clientIP, this);
                for (String str : TCPServerStringManager.this.clients.keySet()) {
                    Log.i((String)"tag", (String)("---" + TCPServerStringManager.this.clients.size() + "-" + str + "-" + this.getClientIP()));
                }
                this.outputStream = new DataOutputStream(socket.getOutputStream());
                this.inputStream = new DataInputStream(socket.getInputStream());
                this.bos = new ByteArrayOutputStream();
                this.reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                this.writer = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private String receiveString() throws IOException {
            return this.reader.readLine();
        }

        private byte[] receiveByte(int byteSize) throws IOException {
            byte[] bytes = new byte[100];
            int len = 0;
            len = this.inputStream.read(bytes);
            this.bos.write(bytes, 0, len);
            bytes = this.bos.toByteArray();
            this.bos.reset();
            return bytes;
        }

        private void sendString(String msg) {
            try {
                this.writer.write(msg);
                this.writer.newLine();
                this.writer.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private void sendByte(byte[] bytes) {
            try {
                this.outputStream.write(bytes, 0, bytes.length);
                this.outputStream.flush();
                Log.i((String)"tag", (String)"---\u53d1\u9001\u5b57\u8282");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private void removeClient() {
            TCPServerStringManager.this.clients.remove(this.getClientIP());
            Message message = Message.obtain();
            message.what = 0;
            message.obj = this.clientIP;
            TCPServerStringManager.this.callback.getHandler().sendMessage(message);
            this.isClientRunning = false;
            this.close();
        }

        private void close() {
            CloseUtil.closeAll(this.inputStream, this.outputStream, this.reader, this.writer, this.socket);
        }

        private void handMessage() {
            Object msg = null;
            try {
                byte[] bytes = this.receiveByte(1024);
                if (bytes.length == 0) {
                    return;
                }
                Message message = Message.obtain();
                message.what = 2;
                message.obj = bytes;
                TCPServerStringManager.this.callback.getHandler().sendMessage(message);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.removeClient();
            }
        }

        private void handByteMessage() {
            try {
                Message message;
                byte[] bytes = this.receiveByte(100);
                Log.i((String)TCPServerStringManager.this.TAG, (String)("---\u63a5\u6536\u5b57\u8282\u957f\u5ea6" + bytes.length));
                if (bytes == null || bytes.length == 0) {
                    return;
                }
                if ((this.clientName == null || this.clientName.equals("")) && bytes.length == 13) {
                    this.clientName = String.valueOf(bytes[1]);
                    message = Message.obtain();
                    message.what = 1;
                    message.obj = this.clientName;
                    TCPServerStringManager.this.callback.getHandler().sendMessage(message);
                    if (bytes[1] == 1) {
                        this.sendByte(new byte[]{-86, 1, -15, 2, 0, 0, -9, -69});
                    } else if (bytes[1] == 2) {
                        this.sendByte(new byte[]{-86, 2, -15, 2, 0, 0, -9, -69});
                    }
                }
                if (bytes.length == 8) {
                    message = Message.obtain();
                    message.what = 2;
                    message.obj = bytes;
                    TCPServerStringManager.this.callback.getHandler().sendMessage(message);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                Log.i((String)"tag", (String)("---" + TCPServerStringManager.this.clients.size() + this.getClientIP()));
                this.removeClient();
            }
        }

        public void sendMessageToClient(byte[] bytes) {
            this.byteMessageToClient = bytes;
        }

        private void startSendThread() {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    while (TCPServerStringManager.this.isServerRunning && ConnectedClient.this.isClientRunning) {
                        if (ConnectedClient.this.byteMessageToClient == null || 0 == ConnectedClient.this.byteMessageToClient.length) continue;
                        ConnectedClient.this.sendByte(ConnectedClient.this.byteMessageToClient);
                        ConnectedClient.access$702(ConnectedClient.this, null);
                    }
                }
            }).start();
        }

        @Override
        public void run() {
            this.startSendThread();
            while (TCPServerStringManager.this.isServerRunning && this.isClientRunning) {
                this.handMessage();
            }
        }

        static /* synthetic */ byte[] access$702(ConnectedClient x0, byte[] x1) {
            x0.byteMessageToClient = x1;
            return x1;
        }
    }
}

