/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.utils;

import android.app.Activity;
import android.util.Log;
import java.lang.ref.WeakReference;
import java.util.Deque;
import java.util.LinkedList;

public class ActivityDequeManager {
    private static final String TAG = "ActivityDequeManager";
    private final Deque<WeakReference<Activity>> mActivityStack = new LinkedList<WeakReference<Activity>>();
    private static ActivityDequeManager activityStackManager = new ActivityDequeManager();

    private ActivityDequeManager() {
    }

    public static ActivityDequeManager getInstance() {
        if (activityStackManager == null) {
            activityStackManager = new ActivityDequeManager();
        }
        return activityStackManager;
    }

    public void addActivity(Activity activity) {
        this.mActivityStack.push(new WeakReference<Activity>(activity));
        Log.i((String)TAG, (String)("activityStack--addActivity--" + this.getActivitySize()));
    }

    public void removeActivity(Activity activity) {
        WeakReference<Activity> targetReference = null;
        for (WeakReference<Activity> weakReference : this.mActivityStack) {
            if (!((Activity)weakReference.get()).equals(activity)) continue;
            targetReference = weakReference;
            break;
        }
        if (targetReference != null) {
            this.mActivityStack.remove(targetReference);
        }
        Log.i((String)TAG, (String)("activityStack--removeActivity--" + this.getActivitySize()));
    }

    public int getActivitySize() {
        return this.mActivityStack.size();
    }

    public WeakReference<Activity> getTopActivity() {
        return this.mActivityStack.peek();
    }

    public void finishAllActivity() {
        while (this.mActivityStack.size() > 0) {
            ((Activity)this.mActivityStack.pop().get()).finish();
        }
        Log.i((String)TAG, (String)("activityStack--finishAllActivity--" + this.getActivitySize()));
    }

    public void finishAboveActivity(Class<? extends Activity> clazz) {
        while (this.mActivityStack.size() > 1 && this.mActivityStack.peek() != null && !clazz.getSimpleName().equals(((Activity)this.mActivityStack.peek().get()).getClass().getSimpleName())) {
            ((Activity)this.mActivityStack.pop().get()).finish();
        }
        Log.i((String)TAG, (String)("activityStack--finishAboveActivity--" + this.getActivitySize()));
    }
}

