/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.utils;

import android.app.Activity;
import android.content.Context;
import android.os.Process;
import android.util.Log;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Stack;

public class ActivityStackManager {
    private static final String TAG = "ActivityStackManager";
    private Stack<WeakReference<Activity>> mActivityStack;
    private static ActivityStackManager activityStackManager = new ActivityStackManager();

    private ActivityStackManager() {
    }

    public static ActivityStackManager getInstance() {
        if (activityStackManager == null) {
            activityStackManager = new ActivityStackManager();
        }
        return activityStackManager;
    }

    public int stackSize() {
        return this.mActivityStack.size();
    }

    public Stack<WeakReference<Activity>> getStack() {
        return this.mActivityStack;
    }

    public void addActivity(WeakReference<Activity> activity) {
        if (this.mActivityStack == null) {
            this.mActivityStack = new Stack();
        }
        this.mActivityStack.add(activity);
    }

    public void removeActivity(WeakReference<Activity> activity) {
        if (this.mActivityStack != null) {
            this.mActivityStack.remove(activity);
        }
    }

    public Activity getTopActivity() {
        Activity activity = (Activity)((WeakReference)this.mActivityStack.lastElement()).get();
        if (null == activity) {
            return null;
        }
        return (Activity)((WeakReference)this.mActivityStack.lastElement()).get();
    }

    public Activity getActivityByClass(Class<?> cls) {
        Activity return_activity = null;
        for (WeakReference weakReference : this.mActivityStack) {
            if (!((Activity)weakReference.get()).getClass().equals(cls)) continue;
            return_activity = (Activity)weakReference.get();
            break;
        }
        return return_activity;
    }

    public void killTopActivity() {
        try {
            WeakReference activity = (WeakReference)this.mActivityStack.lastElement();
            this.killActivity(activity);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.getMessage());
        }
    }

    public void killActivity(WeakReference<Activity> activity) {
        try {
            Iterator iterator = this.mActivityStack.iterator();
            while (iterator.hasNext()) {
                WeakReference stackActivity = (WeakReference)iterator.next();
                if (stackActivity.get() == null) {
                    iterator.remove();
                    continue;
                }
                if (!((Activity)stackActivity.get()).getClass().getName().equals(((Activity)activity.get()).getClass().getName())) continue;
                iterator.remove();
                ((Activity)stackActivity.get()).finish();
                break;
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.getMessage());
        }
    }

    public void killActivity(Class<?> cls) {
        try {
            ListIterator listIterator = this.mActivityStack.listIterator();
            while (listIterator.hasNext()) {
                Activity activity = (Activity)((WeakReference)listIterator.next()).get();
                if (activity == null) {
                    listIterator.remove();
                    continue;
                }
                if (activity.getClass() != cls) continue;
                listIterator.remove();
                if (activity != null) {
                    activity.finish();
                }
                break;
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.getMessage());
        }
    }

    public void killAllActivity() {
        try {
            ListIterator listIterator = this.mActivityStack.listIterator();
            while (listIterator.hasNext()) {
                Activity activity = (Activity)((WeakReference)listIterator.next()).get();
                if (activity != null) {
                    activity.finish();
                }
                listIterator.remove();
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.getMessage());
        }
    }

    public void killAllActivityExceptOne(Class cls) {
        try {
            WeakReference activity;
            for (int i = 0; i < this.mActivityStack.size() && !(activity = (WeakReference)this.mActivityStack.get(i)).getClass().equals(cls); ++i) {
                if (this.mActivityStack.get(i) == null) continue;
                this.killActivity(activity);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.getMessage());
        }
    }

    public void AppExit(Context context) {
        this.killAllActivity();
        Process.killProcess((int)Process.myPid());
    }
}

