/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.utils;

import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.recyclerview.widget.RecyclerView;
import com.bfcy.base.R;
import com.bfcy.base.utils.DisplayUtil;

public class AdapterUtil {
    public static final boolean adapterDefaultLightMode = true;

    public static void dealFirstItem(View view, int position, float left, float top, float right, float bottom) {
        RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)view.getLayoutParams();
        if (position == 0) {
            params.setMargins(DisplayUtil.dp2px(view.getContext(), left), DisplayUtil.dp2px(view.getContext(), top), DisplayUtil.dp2px(view.getContext(), right), DisplayUtil.dp2px(view.getContext(), bottom));
        } else {
            params.setMargins(DisplayUtil.dp2px(view.getContext(), left), 0, DisplayUtil.dp2px(view.getContext(), right), DisplayUtil.dp2px(view.getContext(), bottom));
        }
        view.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public static void dealDivider(View view, int position) {
        AdapterUtil.dealDivider(true, view, position);
    }

    public static void dealDivider(boolean showDivider, View view, int position) {
        if (showDivider) {
            if (position == 0) {
                view.setVisibility(8);
            } else {
                view.setVisibility(0);
            }
        } else {
            view.setVisibility(8);
        }
    }

    public static void setCheckType(boolean isLight, ImageView ivCheck, boolean isCheck, int checkStyle) {
        if (isLight) {
            if (isCheck) {
                ivCheck.setVisibility(0);
                if (checkStyle == 2) {
                    ivCheck.setImageResource(R.drawable.icon_item_check_2);
                } else if (checkStyle == 3) {
                    ivCheck.setImageResource(R.drawable.icon_item_check_3);
                } else {
                    ivCheck.setImageResource(R.drawable.icon_item_check);
                }
            } else {
                ivCheck.setVisibility(8);
            }
        } else if (isCheck) {
            ivCheck.setVisibility(0);
            if (checkStyle == 2) {
                ivCheck.setImageResource(R.drawable.icon_item_check_w_2);
            } else if (checkStyle == 3) {
                ivCheck.setImageResource(R.drawable.icon_item_check_w_3);
            } else {
                ivCheck.setImageResource(R.drawable.icon_item_check_w);
            }
        } else {
            ivCheck.setVisibility(8);
        }
    }
}

